package zio.aws.paymentcryptography.model
import scala.jdk.CollectionConverters._
sealed trait WrappedKeyMaterialFormat {
  def unwrap: software.amazon.awssdk.services.paymentcryptography.model.WrappedKeyMaterialFormat
}
object WrappedKeyMaterialFormat {
  def wrap(
      value: software.amazon.awssdk.services.paymentcryptography.model.WrappedKeyMaterialFormat
  ): zio.aws.paymentcryptography.model.WrappedKeyMaterialFormat = value match {
    case software.amazon.awssdk.services.paymentcryptography.model.WrappedKeyMaterialFormat.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.paymentcryptography.model.WrappedKeyMaterialFormat.KEY_CRYPTOGRAM =>
      val r = KEY_CRYPTOGRAM
      r
    case software.amazon.awssdk.services.paymentcryptography.model.WrappedKeyMaterialFormat.TR31_KEY_BLOCK =>
      val r = TR31_KEY_BLOCK
      r
    case software.amazon.awssdk.services.paymentcryptography.model.WrappedKeyMaterialFormat.TR34_KEY_BLOCK =>
      val r = TR34_KEY_BLOCK
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.paymentcryptography.model.WrappedKeyMaterialFormat {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptography.model.WrappedKeyMaterialFormat =
      software.amazon.awssdk.services.paymentcryptography.model.WrappedKeyMaterialFormat.UNKNOWN_TO_SDK_VERSION
  }
  case object KEY_CRYPTOGRAM
      extends zio.aws.paymentcryptography.model.WrappedKeyMaterialFormat {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptography.model.WrappedKeyMaterialFormat =
      software.amazon.awssdk.services.paymentcryptography.model.WrappedKeyMaterialFormat.KEY_CRYPTOGRAM
  }
  case object TR31_KEY_BLOCK
      extends zio.aws.paymentcryptography.model.WrappedKeyMaterialFormat {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptography.model.WrappedKeyMaterialFormat =
      software.amazon.awssdk.services.paymentcryptography.model.WrappedKeyMaterialFormat.TR31_KEY_BLOCK
  }
  case object TR34_KEY_BLOCK
      extends zio.aws.paymentcryptography.model.WrappedKeyMaterialFormat {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptography.model.WrappedKeyMaterialFormat =
      software.amazon.awssdk.services.paymentcryptography.model.WrappedKeyMaterialFormat.TR34_KEY_BLOCK
  }
}
