package zio.aws.paymentcryptography.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.paymentcryptography.model.primitives.{
  ResourceArn,
  NextToken,
  MaxResults
}
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceRequest(
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    resourceArn: ResourceArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptography.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptography.model.ListTagsForResourceRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .resourceArn(ResourceArn.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptography.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.paymentcryptography.model.ListTagsForResourceRequest
      .wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptography.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.paymentcryptography.model.ListTagsForResourceRequest =
      zio.aws.paymentcryptography.model.ListTagsForResourceRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        resourceArn
      )
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def resourceArn: ResourceArn
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getResourceArn: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptography.model.ListTagsForResourceRequest
  ) extends zio.aws.paymentcryptography.model.ListTagsForResourceRequest.ReadOnly {
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.paymentcryptography.model.primitives.MaxResults(value)
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.paymentcryptography.model.primitives.NextToken(value)
      )
    override val resourceArn: ResourceArn =
      zio.aws.paymentcryptography.model.primitives
        .ResourceArn(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptography.model.ListTagsForResourceRequest
  ): zio.aws.paymentcryptography.model.ListTagsForResourceRequest.ReadOnly =
    new Wrapper(impl)
}
