package zio.aws.paymentcryptography.model
import zio.aws.paymentcryptography.model.primitives.{
  CertificateType,
  Timestamp,
  ExportTokenId
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class GetParametersForExportResponse(
    exportToken: ExportTokenId,
    parametersValidUntilTimestamp: Timestamp,
    signingKeyAlgorithm: zio.aws.paymentcryptography.model.KeyAlgorithm,
    signingKeyCertificate: CertificateType,
    signingKeyCertificateChain: CertificateType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptography.model.GetParametersForExportResponse = {
    import GetParametersForExportResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptography.model.GetParametersForExportResponse
      .builder()
      .exportToken(ExportTokenId.unwrap(exportToken): java.lang.String)
      .parametersValidUntilTimestamp(
        Timestamp.unwrap(parametersValidUntilTimestamp): Instant
      )
      .signingKeyAlgorithm(signingKeyAlgorithm.unwrap)
      .signingKeyCertificate(
        CertificateType.unwrap(signingKeyCertificate): java.lang.String
      )
      .signingKeyCertificateChain(
        CertificateType.unwrap(signingKeyCertificateChain): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptography.model.GetParametersForExportResponse.ReadOnly =
    zio.aws.paymentcryptography.model.GetParametersForExportResponse
      .wrap(buildAwsValue())
}
object GetParametersForExportResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptography.model.GetParametersForExportResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.paymentcryptography.model.GetParametersForExportResponse =
      zio.aws.paymentcryptography.model.GetParametersForExportResponse(
        exportToken,
        parametersValidUntilTimestamp,
        signingKeyAlgorithm,
        signingKeyCertificate,
        signingKeyCertificateChain
      )
    def exportToken: ExportTokenId
    def parametersValidUntilTimestamp: Timestamp
    def signingKeyAlgorithm: zio.aws.paymentcryptography.model.KeyAlgorithm
    def signingKeyCertificate: CertificateType
    def signingKeyCertificateChain: CertificateType
    def getExportToken: ZIO[Any, Nothing, ExportTokenId] =
      ZIO.succeed(exportToken)
    def getParametersValidUntilTimestamp: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(parametersValidUntilTimestamp)
    def getSigningKeyAlgorithm
        : ZIO[Any, Nothing, zio.aws.paymentcryptography.model.KeyAlgorithm] =
      ZIO.succeed(signingKeyAlgorithm)
    def getSigningKeyCertificate: ZIO[Any, Nothing, CertificateType] =
      ZIO.succeed(signingKeyCertificate)
    def getSigningKeyCertificateChain: ZIO[Any, Nothing, CertificateType] =
      ZIO.succeed(signingKeyCertificateChain)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptography.model.GetParametersForExportResponse
  ) extends zio.aws.paymentcryptography.model.GetParametersForExportResponse.ReadOnly {
    override val exportToken: ExportTokenId =
      zio.aws.paymentcryptography.model.primitives
        .ExportTokenId(impl.exportToken())
    override val parametersValidUntilTimestamp: Timestamp =
      zio.aws.paymentcryptography.model.primitives
        .Timestamp(impl.parametersValidUntilTimestamp())
    override val signingKeyAlgorithm
        : zio.aws.paymentcryptography.model.KeyAlgorithm =
      zio.aws.paymentcryptography.model.KeyAlgorithm
        .wrap(impl.signingKeyAlgorithm())
    override val signingKeyCertificate: CertificateType =
      zio.aws.paymentcryptography.model.primitives
        .CertificateType(impl.signingKeyCertificate())
    override val signingKeyCertificateChain: CertificateType =
      zio.aws.paymentcryptography.model.primitives
        .CertificateType(impl.signingKeyCertificateChain())
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptography.model.GetParametersForExportResponse
  ): zio.aws.paymentcryptography.model.GetParametersForExportResponse.ReadOnly =
    new Wrapper(impl)
}
