package zio.aws.paymentcryptography.model
import zio.aws.paymentcryptography.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListAliasesResponse(
    aliases: Iterable[zio.aws.paymentcryptography.model.Alias],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptography.model.ListAliasesResponse = {
    import ListAliasesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptography.model.ListAliasesResponse
      .builder()
      .aliases(aliases.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptography.model.ListAliasesResponse.ReadOnly =
    zio.aws.paymentcryptography.model.ListAliasesResponse.wrap(buildAwsValue())
}
object ListAliasesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptography.model.ListAliasesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.paymentcryptography.model.ListAliasesResponse =
      zio.aws.paymentcryptography.model.ListAliasesResponse(
        aliases.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def aliases: List[zio.aws.paymentcryptography.model.Alias.ReadOnly]
    def nextToken: Optional[NextToken]
    def getAliases: ZIO[Any, Nothing, List[
      zio.aws.paymentcryptography.model.Alias.ReadOnly
    ]] = ZIO.succeed(aliases)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptography.model.ListAliasesResponse
  ) extends zio.aws.paymentcryptography.model.ListAliasesResponse.ReadOnly {
    override val aliases
        : List[zio.aws.paymentcryptography.model.Alias.ReadOnly] = impl
      .aliases()
      .asScala
      .map { item =>
        zio.aws.paymentcryptography.model.Alias.wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.paymentcryptography.model.primitives.NextToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptography.model.ListAliasesResponse
  ): zio.aws.paymentcryptography.model.ListAliasesResponse.ReadOnly =
    new Wrapper(impl)
}
