package zio.aws.paymentcryptography.model
import zio.aws.paymentcryptography.model.primitives.KeyArnOrKeyAliasType
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetKeyRequest(keyIdentifier: KeyArnOrKeyAliasType) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptography.model.GetKeyRequest = {
    import GetKeyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptography.model.GetKeyRequest
      .builder()
      .keyIdentifier(
        KeyArnOrKeyAliasType.unwrap(keyIdentifier): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.paymentcryptography.model.GetKeyRequest.ReadOnly =
    zio.aws.paymentcryptography.model.GetKeyRequest.wrap(buildAwsValue())
}
object GetKeyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptography.model.GetKeyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.paymentcryptography.model.GetKeyRequest =
      zio.aws.paymentcryptography.model.GetKeyRequest(keyIdentifier)
    def keyIdentifier: KeyArnOrKeyAliasType
    def getKeyIdentifier: ZIO[Any, Nothing, KeyArnOrKeyAliasType] =
      ZIO.succeed(keyIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptography.model.GetKeyRequest
  ) extends zio.aws.paymentcryptography.model.GetKeyRequest.ReadOnly {
    override val keyIdentifier: KeyArnOrKeyAliasType =
      zio.aws.paymentcryptography.model.primitives
        .KeyArnOrKeyAliasType(impl.keyIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptography.model.GetKeyRequest
  ): zio.aws.paymentcryptography.model.GetKeyRequest.ReadOnly = new Wrapper(
    impl
  )
}
