package zio.aws.paymentcryptography.model
import zio.aws.paymentcryptography.model.primitives.{KeyArn, AliasName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateAliasRequest(
    aliasName: AliasName,
    keyArn: Optional[KeyArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptography.model.CreateAliasRequest = {
    import CreateAliasRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptography.model.CreateAliasRequest
      .builder()
      .aliasName(AliasName.unwrap(aliasName): java.lang.String)
      .optionallyWith(
        keyArn.map(value => KeyArn.unwrap(value): java.lang.String)
      )(_.keyArn)
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptography.model.CreateAliasRequest.ReadOnly =
    zio.aws.paymentcryptography.model.CreateAliasRequest.wrap(buildAwsValue())
}
object CreateAliasRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptography.model.CreateAliasRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.paymentcryptography.model.CreateAliasRequest =
      zio.aws.paymentcryptography.model
        .CreateAliasRequest(aliasName, keyArn.map(value => value))
    def aliasName: AliasName
    def keyArn: Optional[KeyArn]
    def getAliasName: ZIO[Any, Nothing, AliasName] = ZIO.succeed(aliasName)
    def getKeyArn: ZIO[Any, AwsError, KeyArn] =
      AwsError.unwrapOptionField("keyArn", keyArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptography.model.CreateAliasRequest
  ) extends zio.aws.paymentcryptography.model.CreateAliasRequest.ReadOnly {
    override val aliasName: AliasName =
      zio.aws.paymentcryptography.model.primitives.AliasName(impl.aliasName())
    override val keyArn: Optional[KeyArn] = zio.aws.core.internal
      .optionalFromNullable(impl.keyArn())
      .map(value => zio.aws.paymentcryptography.model.primitives.KeyArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptography.model.CreateAliasRequest
  ): zio.aws.paymentcryptography.model.CreateAliasRequest.ReadOnly =
    new Wrapper(impl)
}
