package zio.aws.osis.model
import zio.aws.osis.model.primitives.{SecurityGroupId, SubnetId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VpcOptions(
    subnetIds: Iterable[SubnetId],
    securityGroupIds: Optional[Iterable[SecurityGroupId]] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.osis.model.VpcOptions = {
    import VpcOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.osis.model.VpcOptions
      .builder()
      .subnetIds(subnetIds.map { item =>
        SubnetId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .build()
  }
  def asReadOnly: zio.aws.osis.model.VpcOptions.ReadOnly =
    zio.aws.osis.model.VpcOptions.wrap(buildAwsValue())
}
object VpcOptions {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.osis.model.VpcOptions] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.osis.model.VpcOptions = zio.aws.osis.model
      .VpcOptions(subnetIds, securityGroupIds.map(value => value))
    def subnetIds: List[SubnetId]
    def securityGroupIds: Optional[List[SecurityGroupId]]
    def getSubnetIds: ZIO[Any, Nothing, List[SubnetId]] = ZIO.succeed(subnetIds)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.osis.model.VpcOptions
  ) extends zio.aws.osis.model.VpcOptions.ReadOnly {
    override val subnetIds: List[SubnetId] = impl
      .subnetIds()
      .asScala
      .map { item =>
        zio.aws.osis.model.primitives.SubnetId(item)
      }
      .toList
    override val securityGroupIds: Optional[List[SecurityGroupId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.osis.model.primitives.SecurityGroupId(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.osis.model.VpcOptions
  ): zio.aws.osis.model.VpcOptions.ReadOnly = new Wrapper(impl)
}
