package zio.aws.osis.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VpcEndpoint(
    vpcEndpointId: Optional[String] = Optional.Absent,
    vpcId: Optional[String] = Optional.Absent,
    vpcOptions: Optional[zio.aws.osis.model.VpcOptions] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.osis.model.VpcEndpoint = {
    import VpcEndpoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.osis.model.VpcEndpoint
      .builder()
      .optionallyWith(vpcEndpointId.map(value => value: java.lang.String))(
        _.vpcEndpointId
      )
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(vpcOptions.map(value => value.buildAwsValue()))(
        _.vpcOptions
      )
      .build()
  }
  def asReadOnly: zio.aws.osis.model.VpcEndpoint.ReadOnly =
    zio.aws.osis.model.VpcEndpoint.wrap(buildAwsValue())
}
object VpcEndpoint {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.osis.model.VpcEndpoint] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.osis.model.VpcEndpoint =
      zio.aws.osis.model.VpcEndpoint(
        vpcEndpointId.map(value => value),
        vpcId.map(value => value),
        vpcOptions.map(value => value.asEditable)
      )
    def vpcEndpointId: Optional[String]
    def vpcId: Optional[String]
    def vpcOptions: Optional[zio.aws.osis.model.VpcOptions.ReadOnly]
    def getVpcEndpointId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcEndpointId", vpcEndpointId)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getVpcOptions
        : ZIO[Any, AwsError, zio.aws.osis.model.VpcOptions.ReadOnly] =
      AwsError.unwrapOptionField("vpcOptions", vpcOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.osis.model.VpcEndpoint
  ) extends zio.aws.osis.model.VpcEndpoint.ReadOnly {
    override val vpcEndpointId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcEndpointId())
      .map(value => value: String)
    override val vpcId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => value: String)
    override val vpcOptions: Optional[zio.aws.osis.model.VpcOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcOptions())
        .map(value => zio.aws.osis.model.VpcOptions.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.osis.model.VpcEndpoint
  ): zio.aws.osis.model.VpcEndpoint.ReadOnly = new Wrapper(impl)
}
