package zio.aws.osis.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ValidationMessage(
    message: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.osis.model.ValidationMessage = {
    import ValidationMessage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.osis.model.ValidationMessage
      .builder()
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .build()
  }
  def asReadOnly: zio.aws.osis.model.ValidationMessage.ReadOnly =
    zio.aws.osis.model.ValidationMessage.wrap(buildAwsValue())
}
object ValidationMessage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.osis.model.ValidationMessage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.osis.model.ValidationMessage =
      zio.aws.osis.model.ValidationMessage(message.map(value => value))
    def message: Optional[String]
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.osis.model.ValidationMessage
  ) extends zio.aws.osis.model.ValidationMessage.ReadOnly {
    override val message: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.osis.model.ValidationMessage
  ): zio.aws.osis.model.ValidationMessage.ReadOnly = new Wrapper(impl)
}
