package zio.aws.osis.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ValidatePipelineResponse(
    isValid: Optional[Boolean] = Optional.Absent,
    errors: Optional[Iterable[zio.aws.osis.model.ValidationMessage]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.osis.model.ValidatePipelineResponse = {
    import ValidatePipelineResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.osis.model.ValidatePipelineResponse
      .builder()
      .optionallyWith(isValid.map(value => value: java.lang.Boolean))(_.isValid)
      .optionallyWith(
        errors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.errors)
      .build()
  }
  def asReadOnly: zio.aws.osis.model.ValidatePipelineResponse.ReadOnly =
    zio.aws.osis.model.ValidatePipelineResponse.wrap(buildAwsValue())
}
object ValidatePipelineResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.osis.model.ValidatePipelineResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.osis.model.ValidatePipelineResponse =
      zio.aws.osis.model.ValidatePipelineResponse(
        isValid.map(value => value),
        errors.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def isValid: Optional[Boolean]
    def errors: Optional[List[zio.aws.osis.model.ValidationMessage.ReadOnly]]
    def getIsValid: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isValid", isValid)
    def getErrors: ZIO[Any, AwsError, List[
      zio.aws.osis.model.ValidationMessage.ReadOnly
    ]] = AwsError.unwrapOptionField("errors", errors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.osis.model.ValidatePipelineResponse
  ) extends zio.aws.osis.model.ValidatePipelineResponse.ReadOnly {
    override val isValid: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isValid())
      .map(value => value: Boolean)
    override val errors
        : Optional[List[zio.aws.osis.model.ValidationMessage.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.osis.model.ValidationMessage.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.osis.model.ValidatePipelineResponse
  ): zio.aws.osis.model.ValidatePipelineResponse.ReadOnly = new Wrapper(impl)
}
