package zio.aws.osis.model
import zio.aws.osis.model.primitives.PipelineConfigurationBody
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ValidatePipelineRequest(
    pipelineConfigurationBody: PipelineConfigurationBody
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.osis.model.ValidatePipelineRequest = {
    import ValidatePipelineRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.osis.model.ValidatePipelineRequest
      .builder()
      .pipelineConfigurationBody(
        PipelineConfigurationBody.unwrap(
          pipelineConfigurationBody
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.osis.model.ValidatePipelineRequest.ReadOnly =
    zio.aws.osis.model.ValidatePipelineRequest.wrap(buildAwsValue())
}
object ValidatePipelineRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.osis.model.ValidatePipelineRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.osis.model.ValidatePipelineRequest =
      zio.aws.osis.model.ValidatePipelineRequest(pipelineConfigurationBody)
    def pipelineConfigurationBody: PipelineConfigurationBody
    def getPipelineConfigurationBody
        : ZIO[Any, Nothing, PipelineConfigurationBody] =
      ZIO.succeed(pipelineConfigurationBody)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.osis.model.ValidatePipelineRequest
  ) extends zio.aws.osis.model.ValidatePipelineRequest.ReadOnly {
    override val pipelineConfigurationBody: PipelineConfigurationBody =
      zio.aws.osis.model.primitives
        .PipelineConfigurationBody(impl.pipelineConfigurationBody())
  }
  def wrap(
      impl: software.amazon.awssdk.services.osis.model.ValidatePipelineRequest
  ): zio.aws.osis.model.ValidatePipelineRequest.ReadOnly = new Wrapper(impl)
}
