package zio.aws.osis.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdatePipelineResponse(
    pipeline: Optional[zio.aws.osis.model.Pipeline] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.osis.model.UpdatePipelineResponse = {
    import UpdatePipelineResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.osis.model.UpdatePipelineResponse
      .builder()
      .optionallyWith(pipeline.map(value => value.buildAwsValue()))(_.pipeline)
      .build()
  }
  def asReadOnly: zio.aws.osis.model.UpdatePipelineResponse.ReadOnly =
    zio.aws.osis.model.UpdatePipelineResponse.wrap(buildAwsValue())
}
object UpdatePipelineResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.osis.model.UpdatePipelineResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.osis.model.UpdatePipelineResponse =
      zio.aws.osis.model
        .UpdatePipelineResponse(pipeline.map(value => value.asEditable))
    def pipeline: Optional[zio.aws.osis.model.Pipeline.ReadOnly]
    def getPipeline: ZIO[Any, AwsError, zio.aws.osis.model.Pipeline.ReadOnly] =
      AwsError.unwrapOptionField("pipeline", pipeline)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.osis.model.UpdatePipelineResponse
  ) extends zio.aws.osis.model.UpdatePipelineResponse.ReadOnly {
    override val pipeline: Optional[zio.aws.osis.model.Pipeline.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pipeline())
        .map(value => zio.aws.osis.model.Pipeline.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.osis.model.UpdatePipelineResponse
  ): zio.aws.osis.model.UpdatePipelineResponse.ReadOnly = new Wrapper(impl)
}
