package zio.aws.osis.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.osis.model.primitives.{
  PipelineConfigurationBody,
  PipelineUnits,
  PipelineName
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class UpdatePipelineRequest(
    pipelineName: PipelineName,
    minUnits: Optional[PipelineUnits] = Optional.Absent,
    maxUnits: Optional[PipelineUnits] = Optional.Absent,
    pipelineConfigurationBody: Optional[PipelineConfigurationBody] =
      Optional.Absent,
    logPublishingOptions: Optional[zio.aws.osis.model.LogPublishingOptions] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.osis.model.UpdatePipelineRequest = {
    import UpdatePipelineRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.osis.model.UpdatePipelineRequest
      .builder()
      .pipelineName(PipelineName.unwrap(pipelineName): java.lang.String)
      .optionallyWith(
        minUnits.map(value => PipelineUnits.unwrap(value): Integer)
      )(_.minUnits)
      .optionallyWith(
        maxUnits.map(value => PipelineUnits.unwrap(value): Integer)
      )(_.maxUnits)
      .optionallyWith(
        pipelineConfigurationBody.map(value =>
          PipelineConfigurationBody.unwrap(value): java.lang.String
        )
      )(_.pipelineConfigurationBody)
      .optionallyWith(logPublishingOptions.map(value => value.buildAwsValue()))(
        _.logPublishingOptions
      )
      .build()
  }
  def asReadOnly: zio.aws.osis.model.UpdatePipelineRequest.ReadOnly =
    zio.aws.osis.model.UpdatePipelineRequest.wrap(buildAwsValue())
}
object UpdatePipelineRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.osis.model.UpdatePipelineRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.osis.model.UpdatePipelineRequest =
      zio.aws.osis.model.UpdatePipelineRequest(
        pipelineName,
        minUnits.map(value => value),
        maxUnits.map(value => value),
        pipelineConfigurationBody.map(value => value),
        logPublishingOptions.map(value => value.asEditable)
      )
    def pipelineName: PipelineName
    def minUnits: Optional[PipelineUnits]
    def maxUnits: Optional[PipelineUnits]
    def pipelineConfigurationBody: Optional[PipelineConfigurationBody]
    def logPublishingOptions
        : Optional[zio.aws.osis.model.LogPublishingOptions.ReadOnly]
    def getPipelineName: ZIO[Any, Nothing, PipelineName] =
      ZIO.succeed(pipelineName)
    def getMinUnits: ZIO[Any, AwsError, PipelineUnits] =
      AwsError.unwrapOptionField("minUnits", minUnits)
    def getMaxUnits: ZIO[Any, AwsError, PipelineUnits] =
      AwsError.unwrapOptionField("maxUnits", maxUnits)
    def getPipelineConfigurationBody
        : ZIO[Any, AwsError, PipelineConfigurationBody] = AwsError
      .unwrapOptionField("pipelineConfigurationBody", pipelineConfigurationBody)
    def getLogPublishingOptions
        : ZIO[Any, AwsError, zio.aws.osis.model.LogPublishingOptions.ReadOnly] =
      AwsError.unwrapOptionField("logPublishingOptions", logPublishingOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.osis.model.UpdatePipelineRequest
  ) extends zio.aws.osis.model.UpdatePipelineRequest.ReadOnly {
    override val pipelineName: PipelineName =
      zio.aws.osis.model.primitives.PipelineName(impl.pipelineName())
    override val minUnits: Optional[PipelineUnits] = zio.aws.core.internal
      .optionalFromNullable(impl.minUnits())
      .map(value => zio.aws.osis.model.primitives.PipelineUnits(value))
    override val maxUnits: Optional[PipelineUnits] = zio.aws.core.internal
      .optionalFromNullable(impl.maxUnits())
      .map(value => zio.aws.osis.model.primitives.PipelineUnits(value))
    override val pipelineConfigurationBody
        : Optional[PipelineConfigurationBody] = zio.aws.core.internal
      .optionalFromNullable(impl.pipelineConfigurationBody())
      .map(value =>
        zio.aws.osis.model.primitives.PipelineConfigurationBody(value)
      )
    override val logPublishingOptions
        : Optional[zio.aws.osis.model.LogPublishingOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logPublishingOptions())
        .map(value => zio.aws.osis.model.LogPublishingOptions.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.osis.model.UpdatePipelineRequest
  ): zio.aws.osis.model.UpdatePipelineRequest.ReadOnly = new Wrapper(impl)
}
