package zio.aws.osis.model
import zio.aws.osis.model.primitives.PipelineArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UntagResourceRequest(
    arn: PipelineArn,
    tagKeys: Iterable[String]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.osis.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.osis.model.UntagResourceRequest
      .builder()
      .arn(PipelineArn.unwrap(arn): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.osis.model.UntagResourceRequest.ReadOnly =
    zio.aws.osis.model.UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.osis.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.osis.model.UntagResourceRequest =
      zio.aws.osis.model.UntagResourceRequest(arn, tagKeys)
    def arn: PipelineArn
    def tagKeys: List[String]
    def getArn: ZIO[Any, Nothing, PipelineArn] = ZIO.succeed(arn)
    def getTagKeys: ZIO[Any, Nothing, List[String]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.osis.model.UntagResourceRequest
  ) extends zio.aws.osis.model.UntagResourceRequest.ReadOnly {
    override val arn: PipelineArn =
      zio.aws.osis.model.primitives.PipelineArn(impl.arn())
    override val tagKeys: List[String] = impl
      .tagKeys()
      .asScala
      .map { item =>
        item: String
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.osis.model.UntagResourceRequest
  ): zio.aws.osis.model.UntagResourceRequest.ReadOnly = new Wrapper(impl)
}
