package zio.aws.osis.model
import zio.aws.osis.model.primitives.PipelineArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TagResourceRequest(
    arn: PipelineArn,
    tags: Iterable[zio.aws.osis.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.osis.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.osis.model.TagResourceRequest
      .builder()
      .arn(PipelineArn.unwrap(arn): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.osis.model.TagResourceRequest.ReadOnly =
    zio.aws.osis.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.osis.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.osis.model.TagResourceRequest =
      zio.aws.osis.model.TagResourceRequest(
        arn,
        tags.map { item =>
          item.asEditable
        }
      )
    def arn: PipelineArn
    def tags: List[zio.aws.osis.model.Tag.ReadOnly]
    def getArn: ZIO[Any, Nothing, PipelineArn] = ZIO.succeed(arn)
    def getTags: ZIO[Any, Nothing, List[zio.aws.osis.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.osis.model.TagResourceRequest
  ) extends zio.aws.osis.model.TagResourceRequest.ReadOnly {
    override val arn: PipelineArn =
      zio.aws.osis.model.primitives.PipelineArn(impl.arn())
    override val tags: List[zio.aws.osis.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.osis.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.osis.model.TagResourceRequest
  ): zio.aws.osis.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
