package zio.aws.osis.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StopPipelineResponse(
    pipeline: Optional[zio.aws.osis.model.Pipeline] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.osis.model.StopPipelineResponse = {
    import StopPipelineResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.osis.model.StopPipelineResponse
      .builder()
      .optionallyWith(pipeline.map(value => value.buildAwsValue()))(_.pipeline)
      .build()
  }
  def asReadOnly: zio.aws.osis.model.StopPipelineResponse.ReadOnly =
    zio.aws.osis.model.StopPipelineResponse.wrap(buildAwsValue())
}
object StopPipelineResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.osis.model.StopPipelineResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.osis.model.StopPipelineResponse = zio.aws.osis.model
      .StopPipelineResponse(pipeline.map(value => value.asEditable))
    def pipeline: Optional[zio.aws.osis.model.Pipeline.ReadOnly]
    def getPipeline: ZIO[Any, AwsError, zio.aws.osis.model.Pipeline.ReadOnly] =
      AwsError.unwrapOptionField("pipeline", pipeline)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.osis.model.StopPipelineResponse
  ) extends zio.aws.osis.model.StopPipelineResponse.ReadOnly {
    override val pipeline: Optional[zio.aws.osis.model.Pipeline.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pipeline())
        .map(value => zio.aws.osis.model.Pipeline.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.osis.model.StopPipelineResponse
  ): zio.aws.osis.model.StopPipelineResponse.ReadOnly = new Wrapper(impl)
}
