package zio.aws.osis.model
import zio.aws.osis.model.primitives.PipelineName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StopPipelineRequest(pipelineName: PipelineName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.osis.model.StopPipelineRequest = {
    import StopPipelineRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.osis.model.StopPipelineRequest
      .builder()
      .pipelineName(PipelineName.unwrap(pipelineName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.osis.model.StopPipelineRequest.ReadOnly =
    zio.aws.osis.model.StopPipelineRequest.wrap(buildAwsValue())
}
object StopPipelineRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.osis.model.StopPipelineRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.osis.model.StopPipelineRequest =
      zio.aws.osis.model.StopPipelineRequest(pipelineName)
    def pipelineName: PipelineName
    def getPipelineName: ZIO[Any, Nothing, PipelineName] =
      ZIO.succeed(pipelineName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.osis.model.StopPipelineRequest
  ) extends zio.aws.osis.model.StopPipelineRequest.ReadOnly {
    override val pipelineName: PipelineName =
      zio.aws.osis.model.primitives.PipelineName(impl.pipelineName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.osis.model.StopPipelineRequest
  ): zio.aws.osis.model.StopPipelineRequest.ReadOnly = new Wrapper(impl)
}
