package zio.aws.osis.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartPipelineResponse(
    pipeline: Optional[zio.aws.osis.model.Pipeline] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.osis.model.StartPipelineResponse = {
    import StartPipelineResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.osis.model.StartPipelineResponse
      .builder()
      .optionallyWith(pipeline.map(value => value.buildAwsValue()))(_.pipeline)
      .build()
  }
  def asReadOnly: zio.aws.osis.model.StartPipelineResponse.ReadOnly =
    zio.aws.osis.model.StartPipelineResponse.wrap(buildAwsValue())
}
object StartPipelineResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.osis.model.StartPipelineResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.osis.model.StartPipelineResponse =
      zio.aws.osis.model
        .StartPipelineResponse(pipeline.map(value => value.asEditable))
    def pipeline: Optional[zio.aws.osis.model.Pipeline.ReadOnly]
    def getPipeline: ZIO[Any, AwsError, zio.aws.osis.model.Pipeline.ReadOnly] =
      AwsError.unwrapOptionField("pipeline", pipeline)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.osis.model.StartPipelineResponse
  ) extends zio.aws.osis.model.StartPipelineResponse.ReadOnly {
    override val pipeline: Optional[zio.aws.osis.model.Pipeline.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pipeline())
        .map(value => zio.aws.osis.model.Pipeline.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.osis.model.StartPipelineResponse
  ): zio.aws.osis.model.StartPipelineResponse.ReadOnly = new Wrapper(impl)
}
