package zio.aws.osis.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.osis.model.primitives.{
  Timestamp,
  PipelineUnits,
  PipelineArn,
  PipelineName
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class PipelineSummary(
    status: Optional[zio.aws.osis.model.PipelineStatus] = Optional.Absent,
    statusReason: Optional[zio.aws.osis.model.PipelineStatusReason] =
      Optional.Absent,
    pipelineName: Optional[PipelineName] = Optional.Absent,
    pipelineArn: Optional[PipelineArn] = Optional.Absent,
    minUnits: Optional[PipelineUnits] = Optional.Absent,
    maxUnits: Optional[PipelineUnits] = Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    lastUpdatedAt: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.osis.model.PipelineSummary = {
    import PipelineSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.osis.model.PipelineSummary
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(statusReason.map(value => value.buildAwsValue()))(
        _.statusReason
      )
      .optionallyWith(
        pipelineName.map(value => PipelineName.unwrap(value): java.lang.String)
      )(_.pipelineName)
      .optionallyWith(
        pipelineArn.map(value => PipelineArn.unwrap(value): java.lang.String)
      )(_.pipelineArn)
      .optionallyWith(
        minUnits.map(value => PipelineUnits.unwrap(value): Integer)
      )(_.minUnits)
      .optionallyWith(
        maxUnits.map(value => PipelineUnits.unwrap(value): Integer)
      )(_.maxUnits)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        lastUpdatedAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedAt)
      .build()
  }
  def asReadOnly: zio.aws.osis.model.PipelineSummary.ReadOnly =
    zio.aws.osis.model.PipelineSummary.wrap(buildAwsValue())
}
object PipelineSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.osis.model.PipelineSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.osis.model.PipelineSummary =
      zio.aws.osis.model.PipelineSummary(
        status.map(value => value),
        statusReason.map(value => value.asEditable),
        pipelineName.map(value => value),
        pipelineArn.map(value => value),
        minUnits.map(value => value),
        maxUnits.map(value => value),
        createdAt.map(value => value),
        lastUpdatedAt.map(value => value)
      )
    def status: Optional[zio.aws.osis.model.PipelineStatus]
    def statusReason: Optional[zio.aws.osis.model.PipelineStatusReason.ReadOnly]
    def pipelineName: Optional[PipelineName]
    def pipelineArn: Optional[PipelineArn]
    def minUnits: Optional[PipelineUnits]
    def maxUnits: Optional[PipelineUnits]
    def createdAt: Optional[Timestamp]
    def lastUpdatedAt: Optional[Timestamp]
    def getStatus: ZIO[Any, AwsError, zio.aws.osis.model.PipelineStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusReason
        : ZIO[Any, AwsError, zio.aws.osis.model.PipelineStatusReason.ReadOnly] =
      AwsError.unwrapOptionField("statusReason", statusReason)
    def getPipelineName: ZIO[Any, AwsError, PipelineName] =
      AwsError.unwrapOptionField("pipelineName", pipelineName)
    def getPipelineArn: ZIO[Any, AwsError, PipelineArn] =
      AwsError.unwrapOptionField("pipelineArn", pipelineArn)
    def getMinUnits: ZIO[Any, AwsError, PipelineUnits] =
      AwsError.unwrapOptionField("minUnits", minUnits)
    def getMaxUnits: ZIO[Any, AwsError, PipelineUnits] =
      AwsError.unwrapOptionField("maxUnits", maxUnits)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLastUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.osis.model.PipelineSummary
  ) extends zio.aws.osis.model.PipelineSummary.ReadOnly {
    override val status: Optional[zio.aws.osis.model.PipelineStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.osis.model.PipelineStatus.wrap(value))
    override val statusReason
        : Optional[zio.aws.osis.model.PipelineStatusReason.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusReason())
        .map(value => zio.aws.osis.model.PipelineStatusReason.wrap(value))
    override val pipelineName: Optional[PipelineName] = zio.aws.core.internal
      .optionalFromNullable(impl.pipelineName())
      .map(value => zio.aws.osis.model.primitives.PipelineName(value))
    override val pipelineArn: Optional[PipelineArn] = zio.aws.core.internal
      .optionalFromNullable(impl.pipelineArn())
      .map(value => zio.aws.osis.model.primitives.PipelineArn(value))
    override val minUnits: Optional[PipelineUnits] = zio.aws.core.internal
      .optionalFromNullable(impl.minUnits())
      .map(value => zio.aws.osis.model.primitives.PipelineUnits(value))
    override val maxUnits: Optional[PipelineUnits] = zio.aws.core.internal
      .optionalFromNullable(impl.maxUnits())
      .map(value => zio.aws.osis.model.primitives.PipelineUnits(value))
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.osis.model.primitives.Timestamp(value))
    override val lastUpdatedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedAt())
      .map(value => zio.aws.osis.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.osis.model.PipelineSummary
  ): zio.aws.osis.model.PipelineSummary.ReadOnly = new Wrapper(impl)
}
