package zio.aws.osis.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PipelineStatusReason(
    description: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.osis.model.PipelineStatusReason = {
    import PipelineStatusReason.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.osis.model.PipelineStatusReason
      .builder()
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .build()
  }
  def asReadOnly: zio.aws.osis.model.PipelineStatusReason.ReadOnly =
    zio.aws.osis.model.PipelineStatusReason.wrap(buildAwsValue())
}
object PipelineStatusReason {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.osis.model.PipelineStatusReason
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.osis.model.PipelineStatusReason =
      zio.aws.osis.model.PipelineStatusReason(description.map(value => value))
    def description: Optional[String]
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.osis.model.PipelineStatusReason
  ) extends zio.aws.osis.model.PipelineStatusReason.ReadOnly {
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.osis.model.PipelineStatusReason
  ): zio.aws.osis.model.PipelineStatusReason.ReadOnly = new Wrapper(impl)
}
