package zio.aws.osis.model
import scala.jdk.CollectionConverters._
sealed trait PipelineStatus {
  def unwrap: software.amazon.awssdk.services.osis.model.PipelineStatus
}
object PipelineStatus {
  def wrap(
      value: software.amazon.awssdk.services.osis.model.PipelineStatus
  ): zio.aws.osis.model.PipelineStatus = value match {
    case software.amazon.awssdk.services.osis.model.PipelineStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.osis.model.PipelineStatus.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.osis.model.PipelineStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.osis.model.PipelineStatus.UPDATING =>
      val r = UPDATING
      r
    case software.amazon.awssdk.services.osis.model.PipelineStatus.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.osis.model.PipelineStatus.CREATE_FAILED =>
      val r = CREATE_FAILED
      r
    case software.amazon.awssdk.services.osis.model.PipelineStatus.UPDATE_FAILED =>
      val r = UPDATE_FAILED
      r
    case software.amazon.awssdk.services.osis.model.PipelineStatus.STARTING =>
      val r = STARTING
      r
    case software.amazon.awssdk.services.osis.model.PipelineStatus.START_FAILED =>
      val r = START_FAILED
      r
    case software.amazon.awssdk.services.osis.model.PipelineStatus.STOPPING =>
      val r = STOPPING
      r
    case software.amazon.awssdk.services.osis.model.PipelineStatus.STOPPED =>
      val r = STOPPED
      r
  }
  case object unknownToSdkVersion extends zio.aws.osis.model.PipelineStatus {
    override def unwrap
        : software.amazon.awssdk.services.osis.model.PipelineStatus =
      software.amazon.awssdk.services.osis.model.PipelineStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATING extends zio.aws.osis.model.PipelineStatus {
    override def unwrap
        : software.amazon.awssdk.services.osis.model.PipelineStatus =
      software.amazon.awssdk.services.osis.model.PipelineStatus.CREATING
  }
  case object ACTIVE extends zio.aws.osis.model.PipelineStatus {
    override def unwrap
        : software.amazon.awssdk.services.osis.model.PipelineStatus =
      software.amazon.awssdk.services.osis.model.PipelineStatus.ACTIVE
  }
  case object UPDATING extends zio.aws.osis.model.PipelineStatus {
    override def unwrap
        : software.amazon.awssdk.services.osis.model.PipelineStatus =
      software.amazon.awssdk.services.osis.model.PipelineStatus.UPDATING
  }
  case object DELETING extends zio.aws.osis.model.PipelineStatus {
    override def unwrap
        : software.amazon.awssdk.services.osis.model.PipelineStatus =
      software.amazon.awssdk.services.osis.model.PipelineStatus.DELETING
  }
  case object CREATE_FAILED extends zio.aws.osis.model.PipelineStatus {
    override def unwrap
        : software.amazon.awssdk.services.osis.model.PipelineStatus =
      software.amazon.awssdk.services.osis.model.PipelineStatus.CREATE_FAILED
  }
  case object UPDATE_FAILED extends zio.aws.osis.model.PipelineStatus {
    override def unwrap
        : software.amazon.awssdk.services.osis.model.PipelineStatus =
      software.amazon.awssdk.services.osis.model.PipelineStatus.UPDATE_FAILED
  }
  case object STARTING extends zio.aws.osis.model.PipelineStatus {
    override def unwrap
        : software.amazon.awssdk.services.osis.model.PipelineStatus =
      software.amazon.awssdk.services.osis.model.PipelineStatus.STARTING
  }
  case object START_FAILED extends zio.aws.osis.model.PipelineStatus {
    override def unwrap
        : software.amazon.awssdk.services.osis.model.PipelineStatus =
      software.amazon.awssdk.services.osis.model.PipelineStatus.START_FAILED
  }
  case object STOPPING extends zio.aws.osis.model.PipelineStatus {
    override def unwrap
        : software.amazon.awssdk.services.osis.model.PipelineStatus =
      software.amazon.awssdk.services.osis.model.PipelineStatus.STOPPING
  }
  case object STOPPED extends zio.aws.osis.model.PipelineStatus {
    override def unwrap
        : software.amazon.awssdk.services.osis.model.PipelineStatus =
      software.amazon.awssdk.services.osis.model.PipelineStatus.STOPPED
  }
}
