package zio.aws.osis.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PipelineBlueprintSummary(
    blueprintName: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.osis.model.PipelineBlueprintSummary = {
    import PipelineBlueprintSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.osis.model.PipelineBlueprintSummary
      .builder()
      .optionallyWith(blueprintName.map(value => value: java.lang.String))(
        _.blueprintName
      )
      .build()
  }
  def asReadOnly: zio.aws.osis.model.PipelineBlueprintSummary.ReadOnly =
    zio.aws.osis.model.PipelineBlueprintSummary.wrap(buildAwsValue())
}
object PipelineBlueprintSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.osis.model.PipelineBlueprintSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.osis.model.PipelineBlueprintSummary =
      zio.aws.osis.model
        .PipelineBlueprintSummary(blueprintName.map(value => value))
    def blueprintName: Optional[String]
    def getBlueprintName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("blueprintName", blueprintName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.osis.model.PipelineBlueprintSummary
  ) extends zio.aws.osis.model.PipelineBlueprintSummary.ReadOnly {
    override val blueprintName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.blueprintName())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.osis.model.PipelineBlueprintSummary
  ): zio.aws.osis.model.PipelineBlueprintSummary.ReadOnly = new Wrapper(impl)
}
