package zio.aws.osis.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PipelineBlueprint(
    blueprintName: Optional[String] = Optional.Absent,
    pipelineConfigurationBody: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.osis.model.PipelineBlueprint = {
    import PipelineBlueprint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.osis.model.PipelineBlueprint
      .builder()
      .optionallyWith(blueprintName.map(value => value: java.lang.String))(
        _.blueprintName
      )
      .optionallyWith(
        pipelineConfigurationBody.map(value => value: java.lang.String)
      )(_.pipelineConfigurationBody)
      .build()
  }
  def asReadOnly: zio.aws.osis.model.PipelineBlueprint.ReadOnly =
    zio.aws.osis.model.PipelineBlueprint.wrap(buildAwsValue())
}
object PipelineBlueprint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.osis.model.PipelineBlueprint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.osis.model.PipelineBlueprint =
      zio.aws.osis.model.PipelineBlueprint(
        blueprintName.map(value => value),
        pipelineConfigurationBody.map(value => value)
      )
    def blueprintName: Optional[String]
    def pipelineConfigurationBody: Optional[String]
    def getBlueprintName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("blueprintName", blueprintName)
    def getPipelineConfigurationBody: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("pipelineConfigurationBody", pipelineConfigurationBody)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.osis.model.PipelineBlueprint
  ) extends zio.aws.osis.model.PipelineBlueprint.ReadOnly {
    override val blueprintName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.blueprintName())
      .map(value => value: String)
    override val pipelineConfigurationBody: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pipelineConfigurationBody())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.osis.model.PipelineBlueprint
  ): zio.aws.osis.model.PipelineBlueprint.ReadOnly = new Wrapper(impl)
}
