package zio.aws.osis.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.osis.model.primitives.{Timestamp, Integer}
import scala.jdk.CollectionConverters._
final case class Pipeline(
    pipelineName: Optional[String] = Optional.Absent,
    pipelineArn: Optional[String] = Optional.Absent,
    minUnits: Optional[Integer] = Optional.Absent,
    maxUnits: Optional[Integer] = Optional.Absent,
    status: Optional[zio.aws.osis.model.PipelineStatus] = Optional.Absent,
    statusReason: Optional[zio.aws.osis.model.PipelineStatusReason] =
      Optional.Absent,
    pipelineConfigurationBody: Optional[String] = Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    lastUpdatedAt: Optional[Timestamp] = Optional.Absent,
    ingestEndpointUrls: Optional[Iterable[String]] = Optional.Absent,
    logPublishingOptions: Optional[zio.aws.osis.model.LogPublishingOptions] =
      Optional.Absent,
    vpcEndpoints: Optional[Iterable[zio.aws.osis.model.VpcEndpoint]] =
      Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.osis.model.Pipeline = {
    import Pipeline.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.osis.model.Pipeline
      .builder()
      .optionallyWith(pipelineName.map(value => value: java.lang.String))(
        _.pipelineName
      )
      .optionallyWith(pipelineArn.map(value => value: java.lang.String))(
        _.pipelineArn
      )
      .optionallyWith(minUnits.map(value => value: java.lang.Integer))(
        _.minUnits
      )
      .optionallyWith(maxUnits.map(value => value: java.lang.Integer))(
        _.maxUnits
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(statusReason.map(value => value.buildAwsValue()))(
        _.statusReason
      )
      .optionallyWith(
        pipelineConfigurationBody.map(value => value: java.lang.String)
      )(_.pipelineConfigurationBody)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        lastUpdatedAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedAt)
      .optionallyWith(
        ingestEndpointUrls.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.ingestEndpointUrls)
      .optionallyWith(logPublishingOptions.map(value => value.buildAwsValue()))(
        _.logPublishingOptions
      )
      .optionallyWith(
        vpcEndpoints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vpcEndpoints)
      .build()
  }
  def asReadOnly: zio.aws.osis.model.Pipeline.ReadOnly =
    zio.aws.osis.model.Pipeline.wrap(buildAwsValue())
}
object Pipeline {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.osis.model.Pipeline] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.osis.model.Pipeline = zio.aws.osis.model.Pipeline(
      pipelineName.map(value => value),
      pipelineArn.map(value => value),
      minUnits.map(value => value),
      maxUnits.map(value => value),
      status.map(value => value),
      statusReason.map(value => value.asEditable),
      pipelineConfigurationBody.map(value => value),
      createdAt.map(value => value),
      lastUpdatedAt.map(value => value),
      ingestEndpointUrls.map(value => value),
      logPublishingOptions.map(value => value.asEditable),
      vpcEndpoints.map(value =>
        value.map { item =>
          item.asEditable
        }
      )
    )
    def pipelineName: Optional[String]
    def pipelineArn: Optional[String]
    def minUnits: Optional[Integer]
    def maxUnits: Optional[Integer]
    def status: Optional[zio.aws.osis.model.PipelineStatus]
    def statusReason: Optional[zio.aws.osis.model.PipelineStatusReason.ReadOnly]
    def pipelineConfigurationBody: Optional[String]
    def createdAt: Optional[Timestamp]
    def lastUpdatedAt: Optional[Timestamp]
    def ingestEndpointUrls: Optional[List[String]]
    def logPublishingOptions
        : Optional[zio.aws.osis.model.LogPublishingOptions.ReadOnly]
    def vpcEndpoints: Optional[List[zio.aws.osis.model.VpcEndpoint.ReadOnly]]
    def getPipelineName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("pipelineName", pipelineName)
    def getPipelineArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("pipelineArn", pipelineArn)
    def getMinUnits: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("minUnits", minUnits)
    def getMaxUnits: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxUnits", maxUnits)
    def getStatus: ZIO[Any, AwsError, zio.aws.osis.model.PipelineStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusReason
        : ZIO[Any, AwsError, zio.aws.osis.model.PipelineStatusReason.ReadOnly] =
      AwsError.unwrapOptionField("statusReason", statusReason)
    def getPipelineConfigurationBody: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("pipelineConfigurationBody", pipelineConfigurationBody)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLastUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
    def getIngestEndpointUrls: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("ingestEndpointUrls", ingestEndpointUrls)
    def getLogPublishingOptions
        : ZIO[Any, AwsError, zio.aws.osis.model.LogPublishingOptions.ReadOnly] =
      AwsError.unwrapOptionField("logPublishingOptions", logPublishingOptions)
    def getVpcEndpoints
        : ZIO[Any, AwsError, List[zio.aws.osis.model.VpcEndpoint.ReadOnly]] =
      AwsError.unwrapOptionField("vpcEndpoints", vpcEndpoints)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.osis.model.Pipeline
  ) extends zio.aws.osis.model.Pipeline.ReadOnly {
    override val pipelineName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.pipelineName())
      .map(value => value: String)
    override val pipelineArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.pipelineArn())
      .map(value => value: String)
    override val minUnits: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.minUnits())
      .map(value => value: Integer)
    override val maxUnits: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxUnits())
      .map(value => value: Integer)
    override val status: Optional[zio.aws.osis.model.PipelineStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.osis.model.PipelineStatus.wrap(value))
    override val statusReason
        : Optional[zio.aws.osis.model.PipelineStatusReason.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusReason())
        .map(value => zio.aws.osis.model.PipelineStatusReason.wrap(value))
    override val pipelineConfigurationBody: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pipelineConfigurationBody())
        .map(value => value: String)
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.osis.model.primitives.Timestamp(value))
    override val lastUpdatedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedAt())
      .map(value => zio.aws.osis.model.primitives.Timestamp(value))
    override val ingestEndpointUrls: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ingestEndpointUrls())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val logPublishingOptions
        : Optional[zio.aws.osis.model.LogPublishingOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logPublishingOptions())
        .map(value => zio.aws.osis.model.LogPublishingOptions.wrap(value))
    override val vpcEndpoints
        : Optional[List[zio.aws.osis.model.VpcEndpoint.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcEndpoints())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.osis.model.VpcEndpoint.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.osis.model.Pipeline
  ): zio.aws.osis.model.Pipeline.ReadOnly = new Wrapper(impl)
}
