package zio.aws.osis.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LogPublishingOptions(
    isLoggingEnabled: Optional[Boolean] = Optional.Absent,
    cloudWatchLogDestination: Optional[
      zio.aws.osis.model.CloudWatchLogDestination
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.osis.model.LogPublishingOptions = {
    import LogPublishingOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.osis.model.LogPublishingOptions
      .builder()
      .optionallyWith(isLoggingEnabled.map(value => value: java.lang.Boolean))(
        _.isLoggingEnabled
      )
      .optionallyWith(
        cloudWatchLogDestination.map(value => value.buildAwsValue())
      )(_.cloudWatchLogDestination)
      .build()
  }
  def asReadOnly: zio.aws.osis.model.LogPublishingOptions.ReadOnly =
    zio.aws.osis.model.LogPublishingOptions.wrap(buildAwsValue())
}
object LogPublishingOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.osis.model.LogPublishingOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.osis.model.LogPublishingOptions =
      zio.aws.osis.model.LogPublishingOptions(
        isLoggingEnabled.map(value => value),
        cloudWatchLogDestination.map(value => value.asEditable)
      )
    def isLoggingEnabled: Optional[Boolean]
    def cloudWatchLogDestination
        : Optional[zio.aws.osis.model.CloudWatchLogDestination.ReadOnly]
    def getIsLoggingEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isLoggingEnabled", isLoggingEnabled)
    def getCloudWatchLogDestination: ZIO[
      Any,
      AwsError,
      zio.aws.osis.model.CloudWatchLogDestination.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cloudWatchLogDestination",
      cloudWatchLogDestination
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.osis.model.LogPublishingOptions
  ) extends zio.aws.osis.model.LogPublishingOptions.ReadOnly {
    override val isLoggingEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isLoggingEnabled())
      .map(value => value: Boolean)
    override val cloudWatchLogDestination
        : Optional[zio.aws.osis.model.CloudWatchLogDestination.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cloudWatchLogDestination())
        .map(value => zio.aws.osis.model.CloudWatchLogDestination.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.osis.model.LogPublishingOptions
  ): zio.aws.osis.model.LogPublishingOptions.ReadOnly = new Wrapper(impl)
}
