package zio.aws.osis.model
import zio.aws.osis.model.primitives.PipelineArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceRequest(arn: PipelineArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.osis.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.osis.model.ListTagsForResourceRequest
      .builder()
      .arn(PipelineArn.unwrap(arn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.osis.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.osis.model.ListTagsForResourceRequest.wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.osis.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.osis.model.ListTagsForResourceRequest =
      zio.aws.osis.model.ListTagsForResourceRequest(arn)
    def arn: PipelineArn
    def getArn: ZIO[Any, Nothing, PipelineArn] = ZIO.succeed(arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.osis.model.ListTagsForResourceRequest
  ) extends zio.aws.osis.model.ListTagsForResourceRequest.ReadOnly {
    override val arn: PipelineArn =
      zio.aws.osis.model.primitives.PipelineArn(impl.arn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.osis.model.ListTagsForResourceRequest
  ): zio.aws.osis.model.ListTagsForResourceRequest.ReadOnly = new Wrapper(impl)
}
