package zio.aws.osis.model
import zio.aws.osis.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListPipelinesResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    pipelines: Optional[Iterable[zio.aws.osis.model.PipelineSummary]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.osis.model.ListPipelinesResponse = {
    import ListPipelinesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.osis.model.ListPipelinesResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        pipelines.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.pipelines)
      .build()
  }
  def asReadOnly: zio.aws.osis.model.ListPipelinesResponse.ReadOnly =
    zio.aws.osis.model.ListPipelinesResponse.wrap(buildAwsValue())
}
object ListPipelinesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.osis.model.ListPipelinesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.osis.model.ListPipelinesResponse =
      zio.aws.osis.model.ListPipelinesResponse(
        nextToken.map(value => value),
        pipelines.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def pipelines: Optional[List[zio.aws.osis.model.PipelineSummary.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getPipelines: ZIO[Any, AwsError, List[
      zio.aws.osis.model.PipelineSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("pipelines", pipelines)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.osis.model.ListPipelinesResponse
  ) extends zio.aws.osis.model.ListPipelinesResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.osis.model.primitives.NextToken(value))
    override val pipelines
        : Optional[List[zio.aws.osis.model.PipelineSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pipelines())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.osis.model.PipelineSummary.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.osis.model.ListPipelinesResponse
  ): zio.aws.osis.model.ListPipelinesResponse.ReadOnly = new Wrapper(impl)
}
