package zio.aws.osis.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListPipelineBlueprintsResponse(
    blueprints: Optional[
      Iterable[zio.aws.osis.model.PipelineBlueprintSummary]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.osis.model.ListPipelineBlueprintsResponse = {
    import ListPipelineBlueprintsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.osis.model.ListPipelineBlueprintsResponse
      .builder()
      .optionallyWith(
        blueprints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.blueprints)
      .build()
  }
  def asReadOnly: zio.aws.osis.model.ListPipelineBlueprintsResponse.ReadOnly =
    zio.aws.osis.model.ListPipelineBlueprintsResponse.wrap(buildAwsValue())
}
object ListPipelineBlueprintsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.osis.model.ListPipelineBlueprintsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.osis.model.ListPipelineBlueprintsResponse =
      zio.aws.osis.model.ListPipelineBlueprintsResponse(
        blueprints.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def blueprints
        : Optional[List[zio.aws.osis.model.PipelineBlueprintSummary.ReadOnly]]
    def getBlueprints: ZIO[Any, AwsError, List[
      zio.aws.osis.model.PipelineBlueprintSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("blueprints", blueprints)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.osis.model.ListPipelineBlueprintsResponse
  ) extends zio.aws.osis.model.ListPipelineBlueprintsResponse.ReadOnly {
    override val blueprints
        : Optional[List[zio.aws.osis.model.PipelineBlueprintSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.blueprints())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.osis.model.PipelineBlueprintSummary.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.osis.model.ListPipelineBlueprintsResponse
  ): zio.aws.osis.model.ListPipelineBlueprintsResponse.ReadOnly = new Wrapper(
    impl
  )
}
