package zio.aws.osis.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetPipelineResponse(
    pipeline: Optional[zio.aws.osis.model.Pipeline] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.osis.model.GetPipelineResponse = {
    import GetPipelineResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.osis.model.GetPipelineResponse
      .builder()
      .optionallyWith(pipeline.map(value => value.buildAwsValue()))(_.pipeline)
      .build()
  }
  def asReadOnly: zio.aws.osis.model.GetPipelineResponse.ReadOnly =
    zio.aws.osis.model.GetPipelineResponse.wrap(buildAwsValue())
}
object GetPipelineResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.osis.model.GetPipelineResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.osis.model.GetPipelineResponse = zio.aws.osis.model
      .GetPipelineResponse(pipeline.map(value => value.asEditable))
    def pipeline: Optional[zio.aws.osis.model.Pipeline.ReadOnly]
    def getPipeline: ZIO[Any, AwsError, zio.aws.osis.model.Pipeline.ReadOnly] =
      AwsError.unwrapOptionField("pipeline", pipeline)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.osis.model.GetPipelineResponse
  ) extends zio.aws.osis.model.GetPipelineResponse.ReadOnly {
    override val pipeline: Optional[zio.aws.osis.model.Pipeline.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pipeline())
        .map(value => zio.aws.osis.model.Pipeline.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.osis.model.GetPipelineResponse
  ): zio.aws.osis.model.GetPipelineResponse.ReadOnly = new Wrapper(impl)
}
