package zio.aws.osis.model
import zio.aws.osis.model.primitives.PipelineName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetPipelineRequest(pipelineName: PipelineName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.osis.model.GetPipelineRequest = {
    import GetPipelineRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.osis.model.GetPipelineRequest
      .builder()
      .pipelineName(PipelineName.unwrap(pipelineName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.osis.model.GetPipelineRequest.ReadOnly =
    zio.aws.osis.model.GetPipelineRequest.wrap(buildAwsValue())
}
object GetPipelineRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.osis.model.GetPipelineRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.osis.model.GetPipelineRequest =
      zio.aws.osis.model.GetPipelineRequest(pipelineName)
    def pipelineName: PipelineName
    def getPipelineName: ZIO[Any, Nothing, PipelineName] =
      ZIO.succeed(pipelineName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.osis.model.GetPipelineRequest
  ) extends zio.aws.osis.model.GetPipelineRequest.ReadOnly {
    override val pipelineName: PipelineName =
      zio.aws.osis.model.primitives.PipelineName(impl.pipelineName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.osis.model.GetPipelineRequest
  ): zio.aws.osis.model.GetPipelineRequest.ReadOnly = new Wrapper(impl)
}
