package zio.aws.osis.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetPipelineChangeProgressResponse(
    changeProgressStatuses: Optional[
      Iterable[zio.aws.osis.model.ChangeProgressStatus]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.osis.model.GetPipelineChangeProgressResponse = {
    import GetPipelineChangeProgressResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.osis.model.GetPipelineChangeProgressResponse
      .builder()
      .optionallyWith(
        changeProgressStatuses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.changeProgressStatuses)
      .build()
  }
  def asReadOnly
      : zio.aws.osis.model.GetPipelineChangeProgressResponse.ReadOnly =
    zio.aws.osis.model.GetPipelineChangeProgressResponse.wrap(buildAwsValue())
}
object GetPipelineChangeProgressResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.osis.model.GetPipelineChangeProgressResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.osis.model.GetPipelineChangeProgressResponse =
      zio.aws.osis.model.GetPipelineChangeProgressResponse(
        changeProgressStatuses.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def changeProgressStatuses
        : Optional[List[zio.aws.osis.model.ChangeProgressStatus.ReadOnly]]
    def getChangeProgressStatuses: ZIO[Any, AwsError, List[
      zio.aws.osis.model.ChangeProgressStatus.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "changeProgressStatuses",
      changeProgressStatuses
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.osis.model.GetPipelineChangeProgressResponse
  ) extends zio.aws.osis.model.GetPipelineChangeProgressResponse.ReadOnly {
    override val changeProgressStatuses
        : Optional[List[zio.aws.osis.model.ChangeProgressStatus.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.changeProgressStatuses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.osis.model.ChangeProgressStatus.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.osis.model.GetPipelineChangeProgressResponse
  ): zio.aws.osis.model.GetPipelineChangeProgressResponse.ReadOnly =
    new Wrapper(impl)
}
