package zio.aws.osis.model
import zio.aws.osis.model.primitives.PipelineName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetPipelineChangeProgressRequest(pipelineName: PipelineName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.osis.model.GetPipelineChangeProgressRequest = {
    import GetPipelineChangeProgressRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.osis.model.GetPipelineChangeProgressRequest
      .builder()
      .pipelineName(PipelineName.unwrap(pipelineName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.osis.model.GetPipelineChangeProgressRequest.ReadOnly =
    zio.aws.osis.model.GetPipelineChangeProgressRequest.wrap(buildAwsValue())
}
object GetPipelineChangeProgressRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.osis.model.GetPipelineChangeProgressRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.osis.model.GetPipelineChangeProgressRequest =
      zio.aws.osis.model.GetPipelineChangeProgressRequest(pipelineName)
    def pipelineName: PipelineName
    def getPipelineName: ZIO[Any, Nothing, PipelineName] =
      ZIO.succeed(pipelineName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.osis.model.GetPipelineChangeProgressRequest
  ) extends zio.aws.osis.model.GetPipelineChangeProgressRequest.ReadOnly {
    override val pipelineName: PipelineName =
      zio.aws.osis.model.primitives.PipelineName(impl.pipelineName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.osis.model.GetPipelineChangeProgressRequest
  ): zio.aws.osis.model.GetPipelineChangeProgressRequest.ReadOnly = new Wrapper(
    impl
  )
}
