package zio.aws.osis.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetPipelineBlueprintResponse(
    blueprint: Optional[zio.aws.osis.model.PipelineBlueprint] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.osis.model.GetPipelineBlueprintResponse = {
    import GetPipelineBlueprintResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.osis.model.GetPipelineBlueprintResponse
      .builder()
      .optionallyWith(blueprint.map(value => value.buildAwsValue()))(
        _.blueprint
      )
      .build()
  }
  def asReadOnly: zio.aws.osis.model.GetPipelineBlueprintResponse.ReadOnly =
    zio.aws.osis.model.GetPipelineBlueprintResponse.wrap(buildAwsValue())
}
object GetPipelineBlueprintResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.osis.model.GetPipelineBlueprintResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.osis.model.GetPipelineBlueprintResponse =
      zio.aws.osis.model
        .GetPipelineBlueprintResponse(blueprint.map(value => value.asEditable))
    def blueprint: Optional[zio.aws.osis.model.PipelineBlueprint.ReadOnly]
    def getBlueprint
        : ZIO[Any, AwsError, zio.aws.osis.model.PipelineBlueprint.ReadOnly] =
      AwsError.unwrapOptionField("blueprint", blueprint)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.osis.model.GetPipelineBlueprintResponse
  ) extends zio.aws.osis.model.GetPipelineBlueprintResponse.ReadOnly {
    override val blueprint
        : Optional[zio.aws.osis.model.PipelineBlueprint.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.blueprint())
        .map(value => zio.aws.osis.model.PipelineBlueprint.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.osis.model.GetPipelineBlueprintResponse
  ): zio.aws.osis.model.GetPipelineBlueprintResponse.ReadOnly = new Wrapper(
    impl
  )
}
