package zio.aws.osis.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetPipelineBlueprintRequest(blueprintName: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.osis.model.GetPipelineBlueprintRequest = {
    import GetPipelineBlueprintRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.osis.model.GetPipelineBlueprintRequest
      .builder()
      .blueprintName(blueprintName: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.osis.model.GetPipelineBlueprintRequest.ReadOnly =
    zio.aws.osis.model.GetPipelineBlueprintRequest.wrap(buildAwsValue())
}
object GetPipelineBlueprintRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.osis.model.GetPipelineBlueprintRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.osis.model.GetPipelineBlueprintRequest =
      zio.aws.osis.model.GetPipelineBlueprintRequest(blueprintName)
    def blueprintName: String
    def getBlueprintName: ZIO[Any, Nothing, String] = ZIO.succeed(blueprintName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.osis.model.GetPipelineBlueprintRequest
  ) extends zio.aws.osis.model.GetPipelineBlueprintRequest.ReadOnly {
    override val blueprintName: String = impl.blueprintName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.osis.model.GetPipelineBlueprintRequest
  ): zio.aws.osis.model.GetPipelineBlueprintRequest.ReadOnly = new Wrapper(impl)
}
