package zio.aws.osis.model
import zio.aws.osis.model.primitives.PipelineName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeletePipelineRequest(pipelineName: PipelineName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.osis.model.DeletePipelineRequest = {
    import DeletePipelineRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.osis.model.DeletePipelineRequest
      .builder()
      .pipelineName(PipelineName.unwrap(pipelineName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.osis.model.DeletePipelineRequest.ReadOnly =
    zio.aws.osis.model.DeletePipelineRequest.wrap(buildAwsValue())
}
object DeletePipelineRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.osis.model.DeletePipelineRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.osis.model.DeletePipelineRequest =
      zio.aws.osis.model.DeletePipelineRequest(pipelineName)
    def pipelineName: PipelineName
    def getPipelineName: ZIO[Any, Nothing, PipelineName] =
      ZIO.succeed(pipelineName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.osis.model.DeletePipelineRequest
  ) extends zio.aws.osis.model.DeletePipelineRequest.ReadOnly {
    override val pipelineName: PipelineName =
      zio.aws.osis.model.primitives.PipelineName(impl.pipelineName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.osis.model.DeletePipelineRequest
  ): zio.aws.osis.model.DeletePipelineRequest.ReadOnly = new Wrapper(impl)
}
