package zio.aws.osis.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreatePipelineResponse(
    pipeline: Optional[zio.aws.osis.model.Pipeline] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.osis.model.CreatePipelineResponse = {
    import CreatePipelineResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.osis.model.CreatePipelineResponse
      .builder()
      .optionallyWith(pipeline.map(value => value.buildAwsValue()))(_.pipeline)
      .build()
  }
  def asReadOnly: zio.aws.osis.model.CreatePipelineResponse.ReadOnly =
    zio.aws.osis.model.CreatePipelineResponse.wrap(buildAwsValue())
}
object CreatePipelineResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.osis.model.CreatePipelineResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.osis.model.CreatePipelineResponse =
      zio.aws.osis.model
        .CreatePipelineResponse(pipeline.map(value => value.asEditable))
    def pipeline: Optional[zio.aws.osis.model.Pipeline.ReadOnly]
    def getPipeline: ZIO[Any, AwsError, zio.aws.osis.model.Pipeline.ReadOnly] =
      AwsError.unwrapOptionField("pipeline", pipeline)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.osis.model.CreatePipelineResponse
  ) extends zio.aws.osis.model.CreatePipelineResponse.ReadOnly {
    override val pipeline: Optional[zio.aws.osis.model.Pipeline.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pipeline())
        .map(value => zio.aws.osis.model.Pipeline.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.osis.model.CreatePipelineResponse
  ): zio.aws.osis.model.CreatePipelineResponse.ReadOnly = new Wrapper(impl)
}
