package zio.aws.osis.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.osis.model.primitives.{
  PipelineConfigurationBody,
  PipelineUnits,
  PipelineName
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class CreatePipelineRequest(
    pipelineName: PipelineName,
    minUnits: PipelineUnits,
    maxUnits: PipelineUnits,
    pipelineConfigurationBody: PipelineConfigurationBody,
    logPublishingOptions: Optional[zio.aws.osis.model.LogPublishingOptions] =
      Optional.Absent,
    vpcOptions: Optional[zio.aws.osis.model.VpcOptions] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.osis.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.osis.model.CreatePipelineRequest = {
    import CreatePipelineRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.osis.model.CreatePipelineRequest
      .builder()
      .pipelineName(PipelineName.unwrap(pipelineName): java.lang.String)
      .minUnits(PipelineUnits.unwrap(minUnits): Integer)
      .maxUnits(PipelineUnits.unwrap(maxUnits): Integer)
      .pipelineConfigurationBody(
        PipelineConfigurationBody.unwrap(
          pipelineConfigurationBody
        ): java.lang.String
      )
      .optionallyWith(logPublishingOptions.map(value => value.buildAwsValue()))(
        _.logPublishingOptions
      )
      .optionallyWith(vpcOptions.map(value => value.buildAwsValue()))(
        _.vpcOptions
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.osis.model.CreatePipelineRequest.ReadOnly =
    zio.aws.osis.model.CreatePipelineRequest.wrap(buildAwsValue())
}
object CreatePipelineRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.osis.model.CreatePipelineRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.osis.model.CreatePipelineRequest =
      zio.aws.osis.model.CreatePipelineRequest(
        pipelineName,
        minUnits,
        maxUnits,
        pipelineConfigurationBody,
        logPublishingOptions.map(value => value.asEditable),
        vpcOptions.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def pipelineName: PipelineName
    def minUnits: PipelineUnits
    def maxUnits: PipelineUnits
    def pipelineConfigurationBody: PipelineConfigurationBody
    def logPublishingOptions
        : Optional[zio.aws.osis.model.LogPublishingOptions.ReadOnly]
    def vpcOptions: Optional[zio.aws.osis.model.VpcOptions.ReadOnly]
    def tags: Optional[List[zio.aws.osis.model.Tag.ReadOnly]]
    def getPipelineName: ZIO[Any, Nothing, PipelineName] =
      ZIO.succeed(pipelineName)
    def getMinUnits: ZIO[Any, Nothing, PipelineUnits] = ZIO.succeed(minUnits)
    def getMaxUnits: ZIO[Any, Nothing, PipelineUnits] = ZIO.succeed(maxUnits)
    def getPipelineConfigurationBody
        : ZIO[Any, Nothing, PipelineConfigurationBody] =
      ZIO.succeed(pipelineConfigurationBody)
    def getLogPublishingOptions
        : ZIO[Any, AwsError, zio.aws.osis.model.LogPublishingOptions.ReadOnly] =
      AwsError.unwrapOptionField("logPublishingOptions", logPublishingOptions)
    def getVpcOptions
        : ZIO[Any, AwsError, zio.aws.osis.model.VpcOptions.ReadOnly] =
      AwsError.unwrapOptionField("vpcOptions", vpcOptions)
    def getTags: ZIO[Any, AwsError, List[zio.aws.osis.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.osis.model.CreatePipelineRequest
  ) extends zio.aws.osis.model.CreatePipelineRequest.ReadOnly {
    override val pipelineName: PipelineName =
      zio.aws.osis.model.primitives.PipelineName(impl.pipelineName())
    override val minUnits: PipelineUnits =
      zio.aws.osis.model.primitives.PipelineUnits(impl.minUnits())
    override val maxUnits: PipelineUnits =
      zio.aws.osis.model.primitives.PipelineUnits(impl.maxUnits())
    override val pipelineConfigurationBody: PipelineConfigurationBody =
      zio.aws.osis.model.primitives
        .PipelineConfigurationBody(impl.pipelineConfigurationBody())
    override val logPublishingOptions
        : Optional[zio.aws.osis.model.LogPublishingOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logPublishingOptions())
        .map(value => zio.aws.osis.model.LogPublishingOptions.wrap(value))
    override val vpcOptions: Optional[zio.aws.osis.model.VpcOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcOptions())
        .map(value => zio.aws.osis.model.VpcOptions.wrap(value))
    override val tags: Optional[List[zio.aws.osis.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.osis.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.osis.model.CreatePipelineRequest
  ): zio.aws.osis.model.CreatePipelineRequest.ReadOnly = new Wrapper(impl)
}
