package zio.aws.osis.model
import zio.aws.osis.model.primitives.LogGroup
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CloudWatchLogDestination(logGroup: LogGroup) {
  def buildAwsValue()
      : software.amazon.awssdk.services.osis.model.CloudWatchLogDestination = {
    import CloudWatchLogDestination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.osis.model.CloudWatchLogDestination
      .builder()
      .logGroup(LogGroup.unwrap(logGroup): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.osis.model.CloudWatchLogDestination.ReadOnly =
    zio.aws.osis.model.CloudWatchLogDestination.wrap(buildAwsValue())
}
object CloudWatchLogDestination {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.osis.model.CloudWatchLogDestination
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.osis.model.CloudWatchLogDestination =
      zio.aws.osis.model.CloudWatchLogDestination(logGroup)
    def logGroup: LogGroup
    def getLogGroup: ZIO[Any, Nothing, LogGroup] = ZIO.succeed(logGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.osis.model.CloudWatchLogDestination
  ) extends zio.aws.osis.model.CloudWatchLogDestination.ReadOnly {
    override val logGroup: LogGroup =
      zio.aws.osis.model.primitives.LogGroup(impl.logGroup())
  }
  def wrap(
      impl: software.amazon.awssdk.services.osis.model.CloudWatchLogDestination
  ): zio.aws.osis.model.CloudWatchLogDestination.ReadOnly = new Wrapper(impl)
}
