package zio.aws.osis.model
import scala.jdk.CollectionConverters._
sealed trait ChangeProgressStatuses {
  def unwrap: software.amazon.awssdk.services.osis.model.ChangeProgressStatuses
}
object ChangeProgressStatuses {
  def wrap(
      value: software.amazon.awssdk.services.osis.model.ChangeProgressStatuses
  ): zio.aws.osis.model.ChangeProgressStatuses = value match {
    case software.amazon.awssdk.services.osis.model.ChangeProgressStatuses.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.osis.model.ChangeProgressStatuses.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.osis.model.ChangeProgressStatuses.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.osis.model.ChangeProgressStatuses.COMPLETED =>
      val r = COMPLETED
      r
    case software.amazon.awssdk.services.osis.model.ChangeProgressStatuses.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.osis.model.ChangeProgressStatuses {
    override def unwrap
        : software.amazon.awssdk.services.osis.model.ChangeProgressStatuses =
      software.amazon.awssdk.services.osis.model.ChangeProgressStatuses.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING extends zio.aws.osis.model.ChangeProgressStatuses {
    override def unwrap
        : software.amazon.awssdk.services.osis.model.ChangeProgressStatuses =
      software.amazon.awssdk.services.osis.model.ChangeProgressStatuses.PENDING
  }
  case object IN_PROGRESS extends zio.aws.osis.model.ChangeProgressStatuses {
    override def unwrap
        : software.amazon.awssdk.services.osis.model.ChangeProgressStatuses =
      software.amazon.awssdk.services.osis.model.ChangeProgressStatuses.IN_PROGRESS
  }
  case object COMPLETED extends zio.aws.osis.model.ChangeProgressStatuses {
    override def unwrap
        : software.amazon.awssdk.services.osis.model.ChangeProgressStatuses =
      software.amazon.awssdk.services.osis.model.ChangeProgressStatuses.COMPLETED
  }
  case object FAILED extends zio.aws.osis.model.ChangeProgressStatuses {
    override def unwrap
        : software.amazon.awssdk.services.osis.model.ChangeProgressStatuses =
      software.amazon.awssdk.services.osis.model.ChangeProgressStatuses.FAILED
  }
}
