package zio.aws.osis.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.osis.model.primitives.{Integer, Timestamp}
import scala.jdk.CollectionConverters._
final case class ChangeProgressStatus(
    startTime: Optional[Timestamp] = Optional.Absent,
    status: Optional[zio.aws.osis.model.ChangeProgressStatuses] =
      Optional.Absent,
    totalNumberOfStages: Optional[Integer] = Optional.Absent,
    changeProgressStages: Optional[
      Iterable[zio.aws.osis.model.ChangeProgressStage]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.osis.model.ChangeProgressStatus = {
    import ChangeProgressStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.osis.model.ChangeProgressStatus
      .builder()
      .optionallyWith(startTime.map(value => Timestamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        totalNumberOfStages.map(value => value: java.lang.Integer)
      )(_.totalNumberOfStages)
      .optionallyWith(
        changeProgressStages.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.changeProgressStages)
      .build()
  }
  def asReadOnly: zio.aws.osis.model.ChangeProgressStatus.ReadOnly =
    zio.aws.osis.model.ChangeProgressStatus.wrap(buildAwsValue())
}
object ChangeProgressStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.osis.model.ChangeProgressStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.osis.model.ChangeProgressStatus =
      zio.aws.osis.model.ChangeProgressStatus(
        startTime.map(value => value),
        status.map(value => value),
        totalNumberOfStages.map(value => value),
        changeProgressStages.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def startTime: Optional[Timestamp]
    def status: Optional[zio.aws.osis.model.ChangeProgressStatuses]
    def totalNumberOfStages: Optional[Integer]
    def changeProgressStages
        : Optional[List[zio.aws.osis.model.ChangeProgressStage.ReadOnly]]
    def getStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.osis.model.ChangeProgressStatuses] =
      AwsError.unwrapOptionField("status", status)
    def getTotalNumberOfStages: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("totalNumberOfStages", totalNumberOfStages)
    def getChangeProgressStages: ZIO[Any, AwsError, List[
      zio.aws.osis.model.ChangeProgressStage.ReadOnly
    ]] =
      AwsError.unwrapOptionField("changeProgressStages", changeProgressStages)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.osis.model.ChangeProgressStatus
  ) extends zio.aws.osis.model.ChangeProgressStatus.ReadOnly {
    override val startTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.osis.model.primitives.Timestamp(value))
    override val status: Optional[zio.aws.osis.model.ChangeProgressStatuses] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.osis.model.ChangeProgressStatuses.wrap(value))
    override val totalNumberOfStages: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.totalNumberOfStages())
      .map(value => value: Integer)
    override val changeProgressStages
        : Optional[List[zio.aws.osis.model.ChangeProgressStage.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.changeProgressStages())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.osis.model.ChangeProgressStage.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.osis.model.ChangeProgressStatus
  ): zio.aws.osis.model.ChangeProgressStatus.ReadOnly = new Wrapper(impl)
}
