package zio.aws.osis.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.osis.model.primitives.Timestamp
import scala.jdk.CollectionConverters._
final case class ChangeProgressStage(
    name: Optional[String] = Optional.Absent,
    status: Optional[zio.aws.osis.model.ChangeProgressStageStatuses] =
      Optional.Absent,
    description: Optional[String] = Optional.Absent,
    lastUpdatedAt: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.osis.model.ChangeProgressStage = {
    import ChangeProgressStage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.osis.model.ChangeProgressStage
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        lastUpdatedAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedAt)
      .build()
  }
  def asReadOnly: zio.aws.osis.model.ChangeProgressStage.ReadOnly =
    zio.aws.osis.model.ChangeProgressStage.wrap(buildAwsValue())
}
object ChangeProgressStage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.osis.model.ChangeProgressStage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.osis.model.ChangeProgressStage =
      zio.aws.osis.model.ChangeProgressStage(
        name.map(value => value),
        status.map(value => value),
        description.map(value => value),
        lastUpdatedAt.map(value => value)
      )
    def name: Optional[String]
    def status: Optional[zio.aws.osis.model.ChangeProgressStageStatuses]
    def description: Optional[String]
    def lastUpdatedAt: Optional[Timestamp]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.osis.model.ChangeProgressStageStatuses] =
      AwsError.unwrapOptionField("status", status)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getLastUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.osis.model.ChangeProgressStage
  ) extends zio.aws.osis.model.ChangeProgressStage.ReadOnly {
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val status
        : Optional[zio.aws.osis.model.ChangeProgressStageStatuses] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.osis.model.ChangeProgressStageStatuses.wrap(value)
        )
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val lastUpdatedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedAt())
      .map(value => zio.aws.osis.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.osis.model.ChangeProgressStage
  ): zio.aws.osis.model.ChangeProgressStage.ReadOnly = new Wrapper(impl)
}
