package zio.aws.osis
import zio.aws.osis.model.PipelineSummary.ReadOnly
import zio.mock.{Proxy, Mock}
import software.amazon.awssdk.services.osis.OsisAsyncClient
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
import zio.aws.osis.model.{
  ListPipelineBlueprintsRequest,
  GetPipelineBlueprintRequest,
  StartPipelineRequest,
  ListTagsForResourceRequest,
  GetPipelineChangeProgressRequest,
  ListPipelinesRequest,
  DeletePipelineRequest,
  StopPipelineRequest,
  UntagResourceRequest,
  GetPipelineRequest,
  CreatePipelineRequest,
  UpdatePipelineRequest,
  ValidatePipelineRequest,
  TagResourceRequest
}
object OsisMock extends Mock[Osis] {
  object GetPipeline
      extends Effect[
        GetPipelineRequest,
        AwsError,
        zio.aws.osis.model.GetPipelineResponse.ReadOnly
      ]
  object StartPipeline
      extends Effect[
        StartPipelineRequest,
        AwsError,
        zio.aws.osis.model.StartPipelineResponse.ReadOnly
      ]
  object StopPipeline
      extends Effect[
        StopPipelineRequest,
        AwsError,
        zio.aws.osis.model.StopPipelineResponse.ReadOnly
      ]
  object UpdatePipeline
      extends Effect[
        UpdatePipelineRequest,
        AwsError,
        zio.aws.osis.model.UpdatePipelineResponse.ReadOnly
      ]
  object ListPipelines extends Stream[ListPipelinesRequest, AwsError, ReadOnly]
  object ListPipelinesPaginated
      extends Effect[
        ListPipelinesRequest,
        AwsError,
        zio.aws.osis.model.ListPipelinesResponse.ReadOnly
      ]
  object ValidatePipeline
      extends Effect[
        ValidatePipelineRequest,
        AwsError,
        zio.aws.osis.model.ValidatePipelineResponse.ReadOnly
      ]
  object GetPipelineChangeProgress
      extends Effect[
        GetPipelineChangeProgressRequest,
        AwsError,
        zio.aws.osis.model.GetPipelineChangeProgressResponse.ReadOnly
      ]
  object GetPipelineBlueprint
      extends Effect[
        GetPipelineBlueprintRequest,
        AwsError,
        zio.aws.osis.model.GetPipelineBlueprintResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.osis.model.UntagResourceResponse.ReadOnly
      ]
  object DeletePipeline
      extends Effect[
        DeletePipelineRequest,
        AwsError,
        zio.aws.osis.model.DeletePipelineResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.osis.model.ListTagsForResourceResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.osis.model.TagResourceResponse.ReadOnly
      ]
  object ListPipelineBlueprints
      extends Effect[
        ListPipelineBlueprintsRequest,
        AwsError,
        zio.aws.osis.model.ListPipelineBlueprintsResponse.ReadOnly
      ]
  object CreatePipeline
      extends Effect[
        CreatePipelineRequest,
        AwsError,
        zio.aws.osis.model.CreatePipelineResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Osis] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, Osis] { rts =>
        zio.ZIO.succeed {
          new Osis {
            val api: OsisAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): Osis = this
            def getPipeline(
                request: GetPipelineRequest
            ): IO[AwsError, zio.aws.osis.model.GetPipelineResponse.ReadOnly] =
              proxy(GetPipeline, request)
            def startPipeline(
                request: StartPipelineRequest
            ): IO[AwsError, zio.aws.osis.model.StartPipelineResponse.ReadOnly] =
              proxy(StartPipeline, request)
            def stopPipeline(
                request: StopPipelineRequest
            ): IO[AwsError, zio.aws.osis.model.StopPipelineResponse.ReadOnly] =
              proxy(StopPipeline, request)
            def updatePipeline(request: UpdatePipelineRequest): IO[
              AwsError,
              zio.aws.osis.model.UpdatePipelineResponse.ReadOnly
            ] = proxy(UpdatePipeline, request)
            def listPipelines(
                request: ListPipelinesRequest
            ): ZStream[Any, AwsError, ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListPipelines, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listPipelinesPaginated(
                request: ListPipelinesRequest
            ): IO[AwsError, zio.aws.osis.model.ListPipelinesResponse.ReadOnly] =
              proxy(ListPipelinesPaginated, request)
            def validatePipeline(request: ValidatePipelineRequest): IO[
              AwsError,
              zio.aws.osis.model.ValidatePipelineResponse.ReadOnly
            ] = proxy(ValidatePipeline, request)
            def getPipelineChangeProgress(
                request: GetPipelineChangeProgressRequest
            ): IO[
              AwsError,
              zio.aws.osis.model.GetPipelineChangeProgressResponse.ReadOnly
            ] = proxy(GetPipelineChangeProgress, request)
            def getPipelineBlueprint(request: GetPipelineBlueprintRequest): IO[
              AwsError,
              zio.aws.osis.model.GetPipelineBlueprintResponse.ReadOnly
            ] = proxy(GetPipelineBlueprint, request)
            def untagResource(
                request: UntagResourceRequest
            ): IO[AwsError, zio.aws.osis.model.UntagResourceResponse.ReadOnly] =
              proxy(UntagResource, request)
            def deletePipeline(request: DeletePipelineRequest): IO[
              AwsError,
              zio.aws.osis.model.DeletePipelineResponse.ReadOnly
            ] = proxy(DeletePipeline, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.osis.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def tagResource(
                request: TagResourceRequest
            ): IO[AwsError, zio.aws.osis.model.TagResourceResponse.ReadOnly] =
              proxy(TagResource, request)
            def listPipelineBlueprints(
                request: ListPipelineBlueprintsRequest
            ): IO[
              AwsError,
              zio.aws.osis.model.ListPipelineBlueprintsResponse.ReadOnly
            ] = proxy(ListPipelineBlueprints, request)
            def createPipeline(request: CreatePipelineRequest): IO[
              AwsError,
              zio.aws.osis.model.CreatePipelineResponse.ReadOnly
            ] = proxy(CreatePipeline, request)
          }
        }
      }
    }
  }
}
