package zio.aws.osis
import zio.aws.osis.model.PipelineSummary.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.osis.{
  OsisAsyncClientBuilder,
  OsisAsyncClient
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.osis.model.{
  ListPipelineBlueprintsRequest,
  ValidatePipelineResponse,
  ListPipelineBlueprintsResponse,
  PipelineSummary,
  GetPipelineBlueprintRequest,
  StopPipelineResponse,
  StartPipelineRequest,
  ListTagsForResourceRequest,
  GetPipelineChangeProgressRequest,
  ListPipelinesRequest,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  UpdatePipelineResponse,
  ListPipelinesResponse,
  CreatePipelineResponse,
  GetPipelineChangeProgressResponse,
  DeletePipelineRequest,
  StopPipelineRequest,
  UntagResourceRequest,
  GetPipelineBlueprintResponse,
  GetPipelineRequest,
  CreatePipelineRequest,
  StartPipelineResponse,
  UpdatePipelineRequest,
  TagResourceResponse,
  DeletePipelineResponse,
  ValidatePipelineRequest,
  GetPipelineResponse,
  TagResourceRequest
}
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait Osis extends AspectSupport[Osis] {
  val api: OsisAsyncClient
  def getPipeline(
      request: zio.aws.osis.model.GetPipelineRequest
  ): IO[AwsError, zio.aws.osis.model.GetPipelineResponse.ReadOnly]
  def startPipeline(
      request: zio.aws.osis.model.StartPipelineRequest
  ): IO[AwsError, zio.aws.osis.model.StartPipelineResponse.ReadOnly]
  def stopPipeline(
      request: zio.aws.osis.model.StopPipelineRequest
  ): IO[AwsError, zio.aws.osis.model.StopPipelineResponse.ReadOnly]
  def updatePipeline(
      request: zio.aws.osis.model.UpdatePipelineRequest
  ): IO[AwsError, zio.aws.osis.model.UpdatePipelineResponse.ReadOnly]
  def listPipelines(
      request: zio.aws.osis.model.ListPipelinesRequest
  ): ZStream[Any, AwsError, ReadOnly]
  def listPipelinesPaginated(
      request: zio.aws.osis.model.ListPipelinesRequest
  ): IO[AwsError, zio.aws.osis.model.ListPipelinesResponse.ReadOnly]
  def validatePipeline(
      request: zio.aws.osis.model.ValidatePipelineRequest
  ): IO[AwsError, zio.aws.osis.model.ValidatePipelineResponse.ReadOnly]
  def getPipelineChangeProgress(
      request: zio.aws.osis.model.GetPipelineChangeProgressRequest
  ): IO[AwsError, zio.aws.osis.model.GetPipelineChangeProgressResponse.ReadOnly]
  def getPipelineBlueprint(
      request: zio.aws.osis.model.GetPipelineBlueprintRequest
  ): IO[AwsError, zio.aws.osis.model.GetPipelineBlueprintResponse.ReadOnly]
  def untagResource(
      request: zio.aws.osis.model.UntagResourceRequest
  ): IO[AwsError, zio.aws.osis.model.UntagResourceResponse.ReadOnly]
  def deletePipeline(
      request: zio.aws.osis.model.DeletePipelineRequest
  ): IO[AwsError, zio.aws.osis.model.DeletePipelineResponse.ReadOnly]
  def listTagsForResource(
      request: zio.aws.osis.model.ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.osis.model.ListTagsForResourceResponse.ReadOnly]
  def tagResource(
      request: zio.aws.osis.model.TagResourceRequest
  ): IO[AwsError, zio.aws.osis.model.TagResourceResponse.ReadOnly]
  def listPipelineBlueprints(
      request: zio.aws.osis.model.ListPipelineBlueprintsRequest
  ): IO[AwsError, zio.aws.osis.model.ListPipelineBlueprintsResponse.ReadOnly]
  def createPipeline(
      request: zio.aws.osis.model.CreatePipelineRequest
  ): IO[AwsError, zio.aws.osis.model.CreatePipelineResponse.ReadOnly]
}
object Osis {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Osis] = customized(identity)
  def customized(
      customization: OsisAsyncClientBuilder => OsisAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Osis] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: OsisAsyncClientBuilder => OsisAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Osis] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = OsisAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[OsisAsyncClient, OsisAsyncClientBuilder](builder);
    b1 <- awsConfig
      .configureHttpClient[OsisAsyncClient, OsisAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
  ) yield new OsisImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class OsisImpl[R](
      override val api: OsisAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Osis
      with AwsServiceBase[R] {
    override val serviceName: String = "Osis"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): OsisImpl[R1] = new OsisImpl(api, newAspect, r)
    def getPipeline(
        request: zio.aws.osis.model.GetPipelineRequest
    ): IO[AwsError, zio.aws.osis.model.GetPipelineResponse.ReadOnly] =
      asyncRequestResponse[GetPipelineRequest, GetPipelineResponse](
        "getPipeline",
        api.getPipeline
      )(request.buildAwsValue())
        .map(zio.aws.osis.model.GetPipelineResponse.wrap)
        .provideEnvironment(r)
    def startPipeline(
        request: zio.aws.osis.model.StartPipelineRequest
    ): IO[AwsError, zio.aws.osis.model.StartPipelineResponse.ReadOnly] =
      asyncRequestResponse[StartPipelineRequest, StartPipelineResponse](
        "startPipeline",
        api.startPipeline
      )(request.buildAwsValue())
        .map(zio.aws.osis.model.StartPipelineResponse.wrap)
        .provideEnvironment(r)
    def stopPipeline(
        request: zio.aws.osis.model.StopPipelineRequest
    ): IO[AwsError, zio.aws.osis.model.StopPipelineResponse.ReadOnly] =
      asyncRequestResponse[StopPipelineRequest, StopPipelineResponse](
        "stopPipeline",
        api.stopPipeline
      )(request.buildAwsValue())
        .map(zio.aws.osis.model.StopPipelineResponse.wrap)
        .provideEnvironment(r)
    def updatePipeline(
        request: zio.aws.osis.model.UpdatePipelineRequest
    ): IO[AwsError, zio.aws.osis.model.UpdatePipelineResponse.ReadOnly] =
      asyncRequestResponse[UpdatePipelineRequest, UpdatePipelineResponse](
        "updatePipeline",
        api.updatePipeline
      )(request.buildAwsValue())
        .map(zio.aws.osis.model.UpdatePipelineResponse.wrap)
        .provideEnvironment(r)
    def listPipelines(
        request: zio.aws.osis.model.ListPipelinesRequest
    ): ZStream[Any, AwsError, ReadOnly] = asyncSimplePaginatedRequest[
      ListPipelinesRequest,
      ListPipelinesResponse,
      PipelineSummary
    ](
      "listPipelines",
      api.listPipelines,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.pipelines().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.osis.model.PipelineSummary.wrap(item))
      .provideEnvironment(r)
    def listPipelinesPaginated(
        request: zio.aws.osis.model.ListPipelinesRequest
    ): IO[AwsError, zio.aws.osis.model.ListPipelinesResponse.ReadOnly] =
      asyncRequestResponse[ListPipelinesRequest, ListPipelinesResponse](
        "listPipelines",
        api.listPipelines
      )(request.buildAwsValue())
        .map(zio.aws.osis.model.ListPipelinesResponse.wrap)
        .provideEnvironment(r)
    def validatePipeline(
        request: zio.aws.osis.model.ValidatePipelineRequest
    ): IO[AwsError, zio.aws.osis.model.ValidatePipelineResponse.ReadOnly] =
      asyncRequestResponse[ValidatePipelineRequest, ValidatePipelineResponse](
        "validatePipeline",
        api.validatePipeline
      )(request.buildAwsValue())
        .map(zio.aws.osis.model.ValidatePipelineResponse.wrap)
        .provideEnvironment(r)
    def getPipelineChangeProgress(
        request: zio.aws.osis.model.GetPipelineChangeProgressRequest
    ): IO[
      AwsError,
      zio.aws.osis.model.GetPipelineChangeProgressResponse.ReadOnly
    ] = asyncRequestResponse[
      GetPipelineChangeProgressRequest,
      GetPipelineChangeProgressResponse
    ]("getPipelineChangeProgress", api.getPipelineChangeProgress)(
      request.buildAwsValue()
    ).map(zio.aws.osis.model.GetPipelineChangeProgressResponse.wrap)
      .provideEnvironment(r)
    def getPipelineBlueprint(
        request: zio.aws.osis.model.GetPipelineBlueprintRequest
    ): IO[AwsError, zio.aws.osis.model.GetPipelineBlueprintResponse.ReadOnly] =
      asyncRequestResponse[
        GetPipelineBlueprintRequest,
        GetPipelineBlueprintResponse
      ]("getPipelineBlueprint", api.getPipelineBlueprint)(
        request.buildAwsValue()
      ).map(zio.aws.osis.model.GetPipelineBlueprintResponse.wrap)
        .provideEnvironment(r)
    def untagResource(
        request: zio.aws.osis.model.UntagResourceRequest
    ): IO[AwsError, zio.aws.osis.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[UntagResourceRequest, UntagResourceResponse](
        "untagResource",
        api.untagResource
      )(request.buildAwsValue())
        .map(zio.aws.osis.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def deletePipeline(
        request: zio.aws.osis.model.DeletePipelineRequest
    ): IO[AwsError, zio.aws.osis.model.DeletePipelineResponse.ReadOnly] =
      asyncRequestResponse[DeletePipelineRequest, DeletePipelineResponse](
        "deletePipeline",
        api.deletePipeline
      )(request.buildAwsValue())
        .map(zio.aws.osis.model.DeletePipelineResponse.wrap)
        .provideEnvironment(r)
    def listTagsForResource(
        request: zio.aws.osis.model.ListTagsForResourceRequest
    ): IO[AwsError, zio.aws.osis.model.ListTagsForResourceResponse.ReadOnly] =
      asyncRequestResponse[
        ListTagsForResourceRequest,
        ListTagsForResourceResponse
      ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
        .map(zio.aws.osis.model.ListTagsForResourceResponse.wrap)
        .provideEnvironment(r)
    def tagResource(
        request: zio.aws.osis.model.TagResourceRequest
    ): IO[AwsError, zio.aws.osis.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[TagResourceRequest, TagResourceResponse](
        "tagResource",
        api.tagResource
      )(request.buildAwsValue())
        .map(zio.aws.osis.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def listPipelineBlueprints(
        request: zio.aws.osis.model.ListPipelineBlueprintsRequest
    ): IO[
      AwsError,
      zio.aws.osis.model.ListPipelineBlueprintsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListPipelineBlueprintsRequest,
      ListPipelineBlueprintsResponse
    ]("listPipelineBlueprints", api.listPipelineBlueprints)(
      request.buildAwsValue()
    ).map(zio.aws.osis.model.ListPipelineBlueprintsResponse.wrap)
      .provideEnvironment(r)
    def createPipeline(
        request: zio.aws.osis.model.CreatePipelineRequest
    ): IO[AwsError, zio.aws.osis.model.CreatePipelineResponse.ReadOnly] =
      asyncRequestResponse[CreatePipelineRequest, CreatePipelineResponse](
        "createPipeline",
        api.createPipeline
      )(request.buildAwsValue())
        .map(zio.aws.osis.model.CreatePipelineResponse.wrap)
        .provideEnvironment(r)
  }
  def getPipeline(request: zio.aws.osis.model.GetPipelineRequest): ZIO[
    zio.aws.osis.Osis,
    AwsError,
    zio.aws.osis.model.GetPipelineResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getPipeline(request))
  def startPipeline(request: zio.aws.osis.model.StartPipelineRequest): ZIO[
    zio.aws.osis.Osis,
    AwsError,
    zio.aws.osis.model.StartPipelineResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startPipeline(request))
  def stopPipeline(request: zio.aws.osis.model.StopPipelineRequest): ZIO[
    zio.aws.osis.Osis,
    AwsError,
    zio.aws.osis.model.StopPipelineResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopPipeline(request))
  def updatePipeline(request: zio.aws.osis.model.UpdatePipelineRequest): ZIO[
    zio.aws.osis.Osis,
    AwsError,
    zio.aws.osis.model.UpdatePipelineResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updatePipeline(request))
  def listPipelines(
      request: zio.aws.osis.model.ListPipelinesRequest
  ): ZStream[zio.aws.osis.Osis, AwsError, ReadOnly] =
    ZStream.serviceWithStream(_.listPipelines(request))
  def listPipelinesPaginated(
      request: zio.aws.osis.model.ListPipelinesRequest
  ): ZIO[
    zio.aws.osis.Osis,
    AwsError,
    zio.aws.osis.model.ListPipelinesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPipelinesPaginated(request))
  def validatePipeline(
      request: zio.aws.osis.model.ValidatePipelineRequest
  ): ZIO[
    zio.aws.osis.Osis,
    AwsError,
    zio.aws.osis.model.ValidatePipelineResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.validatePipeline(request))
  def getPipelineChangeProgress(
      request: zio.aws.osis.model.GetPipelineChangeProgressRequest
  ): ZIO[
    zio.aws.osis.Osis,
    AwsError,
    zio.aws.osis.model.GetPipelineChangeProgressResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getPipelineChangeProgress(request))
  def getPipelineBlueprint(
      request: zio.aws.osis.model.GetPipelineBlueprintRequest
  ): ZIO[
    zio.aws.osis.Osis,
    AwsError,
    zio.aws.osis.model.GetPipelineBlueprintResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getPipelineBlueprint(request))
  def untagResource(request: zio.aws.osis.model.UntagResourceRequest): ZIO[
    zio.aws.osis.Osis,
    AwsError,
    zio.aws.osis.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def deletePipeline(request: zio.aws.osis.model.DeletePipelineRequest): ZIO[
    zio.aws.osis.Osis,
    AwsError,
    zio.aws.osis.model.DeletePipelineResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deletePipeline(request))
  def listTagsForResource(
      request: zio.aws.osis.model.ListTagsForResourceRequest
  ): ZIO[
    zio.aws.osis.Osis,
    AwsError,
    zio.aws.osis.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def tagResource(request: zio.aws.osis.model.TagResourceRequest): ZIO[
    zio.aws.osis.Osis,
    AwsError,
    zio.aws.osis.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def listPipelineBlueprints(
      request: zio.aws.osis.model.ListPipelineBlueprintsRequest
  ): ZIO[
    zio.aws.osis.Osis,
    AwsError,
    zio.aws.osis.model.ListPipelineBlueprintsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPipelineBlueprints(request))
  def createPipeline(request: zio.aws.osis.model.CreatePipelineRequest): ZIO[
    zio.aws.osis.Osis,
    AwsError,
    zio.aws.osis.model.CreatePipelineResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createPipeline(request))
}
