package zio.aws.opsworkscm.model
import zio.ZIO
import zio.aws.opsworkscm.model.primitives.ServerName
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateBackupRequest(
    serverName: ServerName,
    description: Optional[String] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.opsworkscm.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opsworkscm.model.CreateBackupRequest = {
    import CreateBackupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opsworkscm.model.CreateBackupRequest
      .builder()
      .serverName(ServerName.unwrap(serverName): java.lang.String)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.opsworkscm.model.CreateBackupRequest.ReadOnly =
    zio.aws.opsworkscm.model.CreateBackupRequest.wrap(buildAwsValue())
}
object CreateBackupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opsworkscm.model.CreateBackupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opsworkscm.model.CreateBackupRequest =
      zio.aws.opsworkscm.model.CreateBackupRequest(
        serverName,
        description.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def serverName: ServerName
    def description: Optional[String]
    def tags: Optional[List[zio.aws.opsworkscm.model.Tag.ReadOnly]]
    def getServerName: ZIO[Any, Nothing, ServerName] = ZIO.succeed(serverName)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.opsworkscm.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opsworkscm.model.CreateBackupRequest
  ) extends zio.aws.opsworkscm.model.CreateBackupRequest.ReadOnly {
    override val serverName: ServerName =
      zio.aws.opsworkscm.model.primitives.ServerName(impl.serverName())
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val tags: Optional[List[zio.aws.opsworkscm.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.opsworkscm.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opsworkscm.model.CreateBackupRequest
  ): zio.aws.opsworkscm.model.CreateBackupRequest.ReadOnly = new Wrapper(impl)
}
