package zio.aws.opsworkscm.model
import zio.ZIO
import zio.aws.opsworkscm.model.primitives.ServerName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteServerRequest(serverName: ServerName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opsworkscm.model.DeleteServerRequest = {
    import DeleteServerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opsworkscm.model.DeleteServerRequest
      .builder()
      .serverName(ServerName.unwrap(serverName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.opsworkscm.model.DeleteServerRequest.ReadOnly =
    zio.aws.opsworkscm.model.DeleteServerRequest.wrap(buildAwsValue())
}
object DeleteServerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opsworkscm.model.DeleteServerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opsworkscm.model.DeleteServerRequest =
      zio.aws.opsworkscm.model.DeleteServerRequest(serverName)
    def serverName: ServerName
    def getServerName: ZIO[Any, Nothing, ServerName] = ZIO.succeed(serverName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opsworkscm.model.DeleteServerRequest
  ) extends zio.aws.opsworkscm.model.DeleteServerRequest.ReadOnly {
    override val serverName: ServerName =
      zio.aws.opsworkscm.model.primitives.ServerName(impl.serverName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.opsworkscm.model.DeleteServerRequest
  ): zio.aws.opsworkscm.model.DeleteServerRequest.ReadOnly = new Wrapper(impl)
}
