package zio.aws.opsworkscm.model
import zio.ZIO
import zio.aws.opsworkscm.model.primitives.{
  TimeWindowDefinition,
  ServerName,
  Integer
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateServerRequest(
    disableAutomatedBackup: Optional[Boolean] = Optional.Absent,
    backupRetentionCount: Optional[Integer] = Optional.Absent,
    serverName: ServerName,
    preferredMaintenanceWindow: Optional[TimeWindowDefinition] =
      Optional.Absent,
    preferredBackupWindow: Optional[TimeWindowDefinition] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opsworkscm.model.UpdateServerRequest = {
    import UpdateServerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opsworkscm.model.UpdateServerRequest
      .builder()
      .optionallyWith(
        disableAutomatedBackup.map(value => value: java.lang.Boolean)
      )(_.disableAutomatedBackup)
      .optionallyWith(
        backupRetentionCount.map(value => value: java.lang.Integer)
      )(_.backupRetentionCount)
      .serverName(ServerName.unwrap(serverName): java.lang.String)
      .optionallyWith(
        preferredMaintenanceWindow.map(value =>
          TimeWindowDefinition.unwrap(value): java.lang.String
        )
      )(_.preferredMaintenanceWindow)
      .optionallyWith(
        preferredBackupWindow.map(value =>
          TimeWindowDefinition.unwrap(value): java.lang.String
        )
      )(_.preferredBackupWindow)
      .build()
  }
  def asReadOnly: zio.aws.opsworkscm.model.UpdateServerRequest.ReadOnly =
    zio.aws.opsworkscm.model.UpdateServerRequest.wrap(buildAwsValue())
}
object UpdateServerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opsworkscm.model.UpdateServerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opsworkscm.model.UpdateServerRequest =
      zio.aws.opsworkscm.model.UpdateServerRequest(
        disableAutomatedBackup.map(value => value),
        backupRetentionCount.map(value => value),
        serverName,
        preferredMaintenanceWindow.map(value => value),
        preferredBackupWindow.map(value => value)
      )
    def disableAutomatedBackup: Optional[Boolean]
    def backupRetentionCount: Optional[Integer]
    def serverName: ServerName
    def preferredMaintenanceWindow: Optional[TimeWindowDefinition]
    def preferredBackupWindow: Optional[TimeWindowDefinition]
    def getDisableAutomatedBackup: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("disableAutomatedBackup", disableAutomatedBackup)
    def getBackupRetentionCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("backupRetentionCount", backupRetentionCount)
    def getServerName: ZIO[Any, Nothing, ServerName] = ZIO.succeed(serverName)
    def getPreferredMaintenanceWindow
        : ZIO[Any, AwsError, TimeWindowDefinition] = AwsError.unwrapOptionField(
      "preferredMaintenanceWindow",
      preferredMaintenanceWindow
    )
    def getPreferredBackupWindow: ZIO[Any, AwsError, TimeWindowDefinition] =
      AwsError.unwrapOptionField("preferredBackupWindow", preferredBackupWindow)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opsworkscm.model.UpdateServerRequest
  ) extends zio.aws.opsworkscm.model.UpdateServerRequest.ReadOnly {
    override val disableAutomatedBackup: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.disableAutomatedBackup())
        .map(value => value: Boolean)
    override val backupRetentionCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.backupRetentionCount())
      .map(value => value: Integer)
    override val serverName: ServerName =
      zio.aws.opsworkscm.model.primitives.ServerName(impl.serverName())
    override val preferredMaintenanceWindow: Optional[TimeWindowDefinition] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preferredMaintenanceWindow())
        .map(value =>
          zio.aws.opsworkscm.model.primitives.TimeWindowDefinition(value)
        )
    override val preferredBackupWindow: Optional[TimeWindowDefinition] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preferredBackupWindow())
        .map(value =>
          zio.aws.opsworkscm.model.primitives.TimeWindowDefinition(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opsworkscm.model.UpdateServerRequest
  ): zio.aws.opsworkscm.model.UpdateServerRequest.ReadOnly = new Wrapper(impl)
}
