package zio.aws.opsworkscm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RestoreServerResponse(
    server: Optional[zio.aws.opsworkscm.model.Server] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opsworkscm.model.RestoreServerResponse = {
    import RestoreServerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opsworkscm.model.RestoreServerResponse
      .builder()
      .optionallyWith(server.map(value => value.buildAwsValue()))(_.server)
      .build()
  }
  def asReadOnly: zio.aws.opsworkscm.model.RestoreServerResponse.ReadOnly =
    zio.aws.opsworkscm.model.RestoreServerResponse.wrap(buildAwsValue())
}
object RestoreServerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opsworkscm.model.RestoreServerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opsworkscm.model.RestoreServerResponse =
      zio.aws.opsworkscm.model
        .RestoreServerResponse(server.map(value => value.asEditable))
    def server: Optional[zio.aws.opsworkscm.model.Server.ReadOnly]
    def getServer
        : ZIO[Any, AwsError, zio.aws.opsworkscm.model.Server.ReadOnly] =
      AwsError.unwrapOptionField("server", server)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opsworkscm.model.RestoreServerResponse
  ) extends zio.aws.opsworkscm.model.RestoreServerResponse.ReadOnly {
    override val server: Optional[zio.aws.opsworkscm.model.Server.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.server())
        .map(value => zio.aws.opsworkscm.model.Server.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opsworkscm.model.RestoreServerResponse
  ): zio.aws.opsworkscm.model.RestoreServerResponse.ReadOnly = new Wrapper(impl)
}
