package zio.aws.opsworkscm.model
import zio.ZIO
import zio.aws.opsworkscm.model.primitives.{NodeName, ServerName}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AssociateNodeRequest(
    serverName: ServerName,
    nodeName: NodeName,
    engineAttributes: Iterable[zio.aws.opsworkscm.model.EngineAttribute]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opsworkscm.model.AssociateNodeRequest = {
    import AssociateNodeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opsworkscm.model.AssociateNodeRequest
      .builder()
      .serverName(ServerName.unwrap(serverName): java.lang.String)
      .nodeName(NodeName.unwrap(nodeName): java.lang.String)
      .engineAttributes(engineAttributes.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.opsworkscm.model.AssociateNodeRequest.ReadOnly =
    zio.aws.opsworkscm.model.AssociateNodeRequest.wrap(buildAwsValue())
}
object AssociateNodeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opsworkscm.model.AssociateNodeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opsworkscm.model.AssociateNodeRequest =
      zio.aws.opsworkscm.model.AssociateNodeRequest(
        serverName,
        nodeName,
        engineAttributes.map { item =>
          item.asEditable
        }
      )
    def serverName: ServerName
    def nodeName: NodeName
    def engineAttributes
        : List[zio.aws.opsworkscm.model.EngineAttribute.ReadOnly]
    def getServerName: ZIO[Any, Nothing, ServerName] = ZIO.succeed(serverName)
    def getNodeName: ZIO[Any, Nothing, NodeName] = ZIO.succeed(nodeName)
    def getEngineAttributes: ZIO[Any, Nothing, List[
      zio.aws.opsworkscm.model.EngineAttribute.ReadOnly
    ]] = ZIO.succeed(engineAttributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opsworkscm.model.AssociateNodeRequest
  ) extends zio.aws.opsworkscm.model.AssociateNodeRequest.ReadOnly {
    override val serverName: ServerName =
      zio.aws.opsworkscm.model.primitives.ServerName(impl.serverName())
    override val nodeName: NodeName =
      zio.aws.opsworkscm.model.primitives.NodeName(impl.nodeName())
    override val engineAttributes
        : List[zio.aws.opsworkscm.model.EngineAttribute.ReadOnly] = impl
      .engineAttributes()
      .asScala
      .map { item =>
        zio.aws.opsworkscm.model.EngineAttribute.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.opsworkscm.model.AssociateNodeRequest
  ): zio.aws.opsworkscm.model.AssociateNodeRequest.ReadOnly = new Wrapper(impl)
}
