package zio.aws.opsworkscm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeBackupsResponse(
    backups: Optional[Iterable[zio.aws.opsworkscm.model.Backup]] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opsworkscm.model.DescribeBackupsResponse = {
    import DescribeBackupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opsworkscm.model.DescribeBackupsResponse
      .builder()
      .optionallyWith(
        backups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.backups)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.opsworkscm.model.DescribeBackupsResponse.ReadOnly =
    zio.aws.opsworkscm.model.DescribeBackupsResponse.wrap(buildAwsValue())
}
object DescribeBackupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opsworkscm.model.DescribeBackupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opsworkscm.model.DescribeBackupsResponse =
      zio.aws.opsworkscm.model.DescribeBackupsResponse(
        backups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def backups: Optional[List[zio.aws.opsworkscm.model.Backup.ReadOnly]]
    def nextToken: Optional[String]
    def getBackups
        : ZIO[Any, AwsError, List[zio.aws.opsworkscm.model.Backup.ReadOnly]] =
      AwsError.unwrapOptionField("backups", backups)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opsworkscm.model.DescribeBackupsResponse
  ) extends zio.aws.opsworkscm.model.DescribeBackupsResponse.ReadOnly {
    override val backups
        : Optional[List[zio.aws.opsworkscm.model.Backup.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.opsworkscm.model.Backup.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.opsworkscm.model.DescribeBackupsResponse
  ): zio.aws.opsworkscm.model.DescribeBackupsResponse.ReadOnly = new Wrapper(
    impl
  )
}
