package zio.aws.opsworkscm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class StartMaintenanceResponse(
    server: Optional[zio.aws.opsworkscm.model.Server] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opsworkscm.model.StartMaintenanceResponse = {
    import StartMaintenanceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opsworkscm.model.StartMaintenanceResponse
      .builder()
      .optionallyWith(server.map(value => value.buildAwsValue()))(_.server)
      .build()
  }
  def asReadOnly: zio.aws.opsworkscm.model.StartMaintenanceResponse.ReadOnly =
    zio.aws.opsworkscm.model.StartMaintenanceResponse.wrap(buildAwsValue())
}
object StartMaintenanceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opsworkscm.model.StartMaintenanceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opsworkscm.model.StartMaintenanceResponse =
      zio.aws.opsworkscm.model
        .StartMaintenanceResponse(server.map(value => value.asEditable))
    def server: Optional[zio.aws.opsworkscm.model.Server.ReadOnly]
    def getServer
        : ZIO[Any, AwsError, zio.aws.opsworkscm.model.Server.ReadOnly] =
      AwsError.unwrapOptionField("server", server)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opsworkscm.model.StartMaintenanceResponse
  ) extends zio.aws.opsworkscm.model.StartMaintenanceResponse.ReadOnly {
    override val server: Optional[zio.aws.opsworkscm.model.Server.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.server())
        .map(value => zio.aws.opsworkscm.model.Server.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opsworkscm.model.StartMaintenanceResponse
  ): zio.aws.opsworkscm.model.StartMaintenanceResponse.ReadOnly = new Wrapper(
    impl
  )
}
